myApps设计时RESTful API说明文档 V1.0

## 1.  RESTful API 设计规范与约定说明
### **路径规则（Endpoint rule）**

路径又称"终点"（endpoint），表示API的具体网址。

在RESTful架构中，每个网址代表一种资源（resource），所以网址中不能有动词，只能有名词，而且所用的名词往往与数据库的表格名对应。一般来说，数据库中的表都是同种记录的"集合"（collection），所以API中的名词也应该使用复数。

举例来说，有一组API分别提供软件、表单、视图的信息，则它的路径应该设计成下面这样。
```
-   https://api.example.com/api/designtime/applications

-   https://api.example.com/api/designtime/forms

-   https://api.example.com/api/designtime/views
```
以上路径规则是面向资源的，对于CRUD操作是非常友好的，但是面向一些“动作”或“行为”等一些不符合CRUD的服务请求（如操作按钮的运行执行前脚本），单纯的面向资源的路径构建规则就会让人困惑了。

这种情况我们可以以“子资源”来对待（资源后面加行为动词），例如:GitHub上，对一个gists加星操作：
```
PUT /gists/:id/star
```
并且取消星操作：
```
DELETE /gists/:id/star
```

### **HTTP动词 (Http method)**

对于资源的具体操作类型，由HTTP动词表示。

常用的HTTP动词有下面五个（括号里是对应的SQL命令）。
```
-   GET（SELECT）：从服务器取出资源（一项或多项）。

-   POST（CREATE）：在服务器新建一个资源。

-   PUT（UPDATE）：在服务器更新资源（客户端提供改变后的完整资源）。

-   PATCH（UPDATE）：在服务器更新资源（客户端提供改变的属性）。

-   DELETE（DELETE）：从服务器删除资源。
```
下面是一些例子。
```
-   GET /runtime/documents：获取Document集合

-   POST /runtime/documents：新建一个Document

-   GET /runtime/documents/{id}：获取由ID指定的Document

-   PUT /runtime/documents/{id}：更新由ID指定的Document（客户端提供全部信息，完整更新）

-   PATCH /runtime/documents/{id}：更新由ID指定的Document（客户端提供部分信息，局部更新）

-   DELETE /runtime/documents/{id}：删除由ID指定的Document
```

### **过滤信息（Filtering）**

如果记录数量很多，服务器不可能都将它们返回给用户。API应该提供参数，过滤返回结果。

下面是一些常见的参数。
```
-   ?_page=2&_page_lines=30：指定第几页，以及每页的记录数。

-   ?_sortby=name&_order=asc：指定返回结果按照哪个属性排序，以及排序顺序。

-   ?form_type =1：指定筛选条件。
```
参数的设计允许存在冗余，即允许API路径和URL参数偶尔有重复。比如，
```
GET /api/designtime/forms/{id}/activitys
```
 与 
```
GET /runtime/activitys?formId={id}
```
的含义是相同的。

### **状态码（Status codes）**
----------------------

服务器向用户返回的状态码和提示信息，常见的有以下一些（方括号中是该状态码对应的HTTP动词）。

下面是一些常见的状态码。
```
-   200 OK - [GET]：服务器成功返回用户请求的数据，该操作是幂等的（Idempotent）。

-   201 CREATED - [POST/PUT/PATCH]：用户新建或修改数据成功。

-   202 Accepted - [\*]：表示一个请求已经进入后台排队（异步任务）

-   204 NO CONTENT - [DELETE]：用户删除数据成功。

-   400 INVALID REQUEST -
    [POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作，该操作是幂等的。

-   401 Unauthorized - [\*]：表示用户没有权限（令牌、用户名、密码错误）。

-   403 Forbidden - [\*] 表示用户得到授权（与401错误相对），但是访问是被禁止的。

-   404 NOT FOUND -
    [\*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的。

-   406 Not Acceptable -
    [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）。

-   410 Gone -[GET]：用户请求的资源被永久删除，且不会再得到的。

-   422 Unprocesable entity - [POST/PUT/PATCH]
    当创建一个对象时，发生一个验证错误。

-   500 INTERNAL SERVER ERROR -
    [\*]：服务器发生错误，用户将无法判断发出的请求是否成功。
```

### **错误处理（Error handling）**

就像html错误页面能够显示错误信息一样，API
也应该能返回可读的错误信息，它应该和一般的资源格式一致。

-   API应该始终返回相应的状态码，以反映服务器或者请求的状态。

-   API的错误码可以分为两部分，400系列和500系列，400系列表明客户端错误：如错误的请求格式等。500系列表示服务器错误。

-   API应该至少将所有的400系列的错误以JSON形式返回。如果可能500系列的错误也应该如此。

-   JSON格式的错误应该包含以下信息：一个有用的错误信息，一个唯一的错误码，以及任何可能的详细错误描述。如下：


```
{
  "errcode" : 40035,
  "errmsg" : "不合法的参数"
}

```

-   对PUT,POST,PATCH的输入的校验也应该返回相应的详细错误信息，例如：


```
{  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 1234,  
              "field" : "first_name",  
              "errmsg" : "First name cannot have fancy characters"  
            },  
            {  
               "errcode" : 1234,  
               "field" : "password",  
               "errmsg" : "Password cannot be blank"  
            }  
          ]  
        }

```

### **数据结构（Data structure）**

-   在POST,PUT,PATCH上使用JSON作为输入。

-   注意使用JSON传输的时候，要求请求头里面加入：Content-Type：applicatin/json.否则抛出415异常（unsupported
    media type）。

-   服务器返回的数据格式，统一使用JSON作为输出。

>   服务器返回的JSON数据结构统一如下：

```
{
  "errcode" : 0,
  "errmsg" : "some message",
  "data" : {},
  "errors" : []
}

```

>   参数说明：

| 参数    | 必须 | 说明                 |
|---------|------|----------------------|
| errcode | 是   | 状态码/返回码        |
| errmsg  | 是   | 消息                 |
| data    | 是   | 服务端返回的数据对象 |
| errors  | 否   | 详细错误信息         |

### **其他**
----

1.  客户端控制服务端是否需要返回数据、且返回哪些数据的约定

2.  Urls命名规则统一使用蛇形命名法（下划线和小写）

## 2.  **登陆模块（logins）**
### **登陆**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/login

**参数说明：**

**请求包体：**

```
{
    "username":"abc",
    "password":"1234",
    "checkcodeimg":"ssss"
}

```

**包体参数说明：**

| **参数**     | **说明**           |
|--------------|--------------------|
| username     | 用户账号           |
| password     | 用户密码           |
| checkcodeimg | 验证码（base64）   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "msg":"登陆成功",
        "checkcodeimg":"验证码"
    }
}

```

**参数说明：**

| **参数**            | **说明**                           |
|---------------------|------------------------------------|
| errcode             | 返回码                             |
| errmsg              | 状态码对应的信息文本               |
| data                | 返回数据                           |
| $.data.msg          | 信息                               |
| $.data.checkcodeimg | 验证码（base64）                   |

### **注销**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/logout

**参数说明：**

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 3.  **软件（applications）**
### **获取软件列表**
----------
**请求方式：** GET  
**请求地址：**/api/designtime/applications?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**         |
|---------------|----------|------------------|
| searchword    | 否       | 查询名称 |
| pageNo        | 否       | 第几页       |
| linesPerPage  | 否       | 每页显示条数 |

**权限说明：**

无。

**返回结果：**


```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 3,
        "linesPerPage": 2147483647,
        "pageNo": 1,
        "datas": [
            {
                "id": "aaITQNiVuTz324lCKD1",
                "name": "KM",
                "type": 0,
                "description": "obpm的km装用软件",
                "activated": true
            },
            {
                "id": "sOZu9kthmxyP8qQfq0e",
                "name": "4.0功能示例",
                "type": 0,
                "description": "适用于4.0+版本的功能测试",
                "activated": true
            },
            {
                "id": "__rn7jHtWcWVGkgBDKaHr",
                "name": "新建的软件",
                "type": 0,
                "description": "新建的软件",
                "activated": true
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数**            | **说明**               |
| ------------------- | ---------------------- |
| errcode             | 返回码                 |
| errmsg              | 对返回码的文本描述内容 |
| data                | 返回数据               |
| $.data.datas.id           | 软件id                 |
| $.data.datas.name         | 软件名称               |
| $.data.datas.description  | 描述                   |
| $.data.rowCount  | 总条数                   |
| $.data.linesPerPage  | 每页显示条数                   |
| $.data.pageNo  | 第几页                   |
| $.data.pageCount  | 总页数                   |

### **获取软件详情**

**请求方式：** GET  
**请求地址：**/api/designtime/applications/{applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "description": "description",
        "type": 1,
        "activated": true,
        "orderNo": 1,
        "datasourceId": "datasourceId",
        "datasourceName": "datasourceName"
    }
}

```

**参数说明：**

| **参数**            | **说明**               |
|---------------------|------------------------|
| errcode             | 返回码                 |
| errmsg              | 对返回码的文本描述内容 |
| data                | 返回数据               |
| $.data.id           | 软件id                 |
| $.data.name         | 软件名称               |
| $.data.description  | 描述                   |
| $.data.type         | 开发模式               |
| $.data.activated    | 激活状态               |
| $.data.orderNo      | 排序号                 |
| $.data.datasourceId | 数据源id               |

### **新建软件**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications

**参数说明：**

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "type": 1,
    "activated": true,
    "orderNo": 1,
    "datasourceId": "datasourceId"
}

```

**包体参数说明：**

| **参数**     | **说明** |
|--------------|----------|
| name         | 软件名称 |
| description  | 描述     |
| type         | 开发模式 |
| activated    | 激活状态 |
| orderNo      | 排序号   |
| datasourceId | 数据源id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**            | **说明**             |
|---------------------|----------------------|
| errcode             | 返回码               |
| errmsg              | 状态码对应的信息文本 |
| data                | 返回数据             |
| $.data.id           | 软件id               |

### **更新软件**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "type": 1,
    "activated": true,
    "orderNo": 1,
    "datasourceId": "datasourceId"
}

```

**包体参数说明：**

| **参数**     | **说明** |
|--------------|----------|
| name         | 软件名称 |
| description  | 描述     |
| type         | 开发模式 |
| activated    | 激活状态 |
| orderNo      | 排序号   |
| datasourceId | 数据源id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
|----------|----------------------|
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### **删除软件**（可批量）
----------
**请求方式：** DELETE  
**请求地址：** /api/designtime/applications

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体：**

```json
[
    "id1",
    "id2"
]
```

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id1      | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **生成概览**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/overview

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
数据

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|

### **获取平台模式回调日志**

----------

**请求方式：** GET

**请求地址：** /api/designtime/applications/{applicationId}/getCallBackLogs

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
            {
                "targetHost": "服务器地址",
                "callBackTime": "回调时间",
                "callBackResult": "回调结果",
                "callBackParam": "回到参数",
                "token": "令牌",
                "key": "密钥"
            }
      ]
   
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

## 3.  **模块（Modules）**

### **获取模块列表（根据上级获取）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/modules?parentId={parentId}

**参数说明：**

| **参数** | **必须** | **说明**                         |
| -------- | -------- | -------------------------------- |
| parentId | 否       | 上级id（顶级模块上级id为软件id） |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"superior": "__lztGCe2TRNqowHluDem",
		"hasChild": false,
		"name": "导出导入数据",
		"id": "__N5tQwhFZNLHo7S7nFpd",
		"applicationId": "sOZu9kthmxyP8qQfq0e",
		"uri": "/4.0功能示例.application/高级应用.module/导出导入数据.module/导出导入数据.module"
	}, {
		"superior": "__lztGCe2TRNqowHluDem",
		"hasChild": false,
		"name": "iscript应用",
		"id": "__PX4mEhGcLp6nUIrchka",
		"applicationId": "sOZu9kthmxyP8qQfq0e",
		"uri": "/4.0功能示例.application/高级应用.module/iscript应用.module/iscript应用.module"
	}]
}
```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 模块id               |
| $.data.name        | 模块名称             |
| $.data.description | 描述                 |
| $.data.superior    | 上级模块id           |
| $.data.orderNo     | 排序号               |

### **获取模块详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/modules/{moduleId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| moduleId | 是       | 模块id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"superiorName": "报表",
		"orderNo": 0,
		"name": "报表示例",
		"description": "",
		"id": "__jdnS7aKT9LklWZGoZgD",
		"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.module",
		"superior": "__rqFRoJeZB0x0DvHwY2v"
	}
}
```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 模块id               |
| $.data.name        | 模块名称             |
| $.data.description | 描述                 |
| $.data.superior    | 上级模块id           |
| $.data.orderNo     | 排序号               |

### **新建模块**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/modules

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "superior": "superior",
    "orderNo": 1
}
```

**包体参数说明：**

| **参数**    | **说明**    |
|-------------|-------------|
| name        | 模块名称    |
| description | 描述        |
| superior    | 上级模块id  |
| orderNo     | 排序号      |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 模块id               |

### **更新模块**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId |    是    | 模块id   |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "superior": "superior",
    "orderNo": 1
}
```

**包体参数说明：**

| **参数**    | **说明**    |
|-------------|-------------|
| name        | 模块名称    |
| description | 描述        |
| superior    | 上级模块id  |
| orderNo     | 排序号      |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除模块**
----------
**请求方式：** DELETE 
**请求地址：** /api/designtime/applications/modules

**参数说明：**


**请求包体：**

```
[
    "id1",
    "id2"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取树形结构所有模块列表**

------

**请求方式：** GET 
**请求地址：** /api/designtime/applications/{applicationId}/allmodules?currentModuleId={currentModuleId}

**参数说明：**

| **参数**        | **必须** | **说明**   |
| --------------- | -------- | ---------- |
| applicationId   | 是       | 软件id     |
| currentModuleId | 否       | 当前模块id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"id": "",
		"value": "无"
	}, {
		"id": "__CAQYDSxmmOxMhrnq9b5",
		"value": "接口测试"
	}, {
		"id": "__nIR7tcVaHuUwph5r4cc",
		"value": "|---请假测试"
	}]
}
```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

## 4.  **表单（Forms）**

### **获取表单列表（可根据名字或者描述查询）**
----------
**请求方式：** GET 
**请求地址：** /api/designtime/applications/modules/{moduleId}/forms?name={name}&description={description}&type={type}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**         |
|---------------|----------|------------------|
| applicationId |    是    | 软件id           |
| moduleId      |    是    | 模块id   		  |
| name    |    否    | 查询名称 |
| description    |    否    | 查询描述 |
| type          | 否       | 表单类型         |
| pageNo | 否 | 当前页数 |
| linesPerPage | 否       | 每页行数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 6,
		"linesPerPage": 1,
		"pageNo": 1,
		"datas": [{
			"id": "NEo0BVgwvHgTNWM5bQ1",
			"name": "类型_普通表单",
			"type": 1,
			"showLog": false,
			"showWaterMark": false,
			"waterMarkScript": "(function(){\nreturn \"显示这段文字为水印不正常\";\n})()",
			"version": 3,
			"mappingStr": "{\"formName\":\"类型_普通表单\",\"tableName\":\"\",\"columnMappings\":[]}",
			"checkout": false,
			"orderno": 1,
			"permissionType": "public",
			"layoutType": "horizontal",
			"typeName": "NORMALFORM",
			"inited": false
		}],
		"pageCount": 6
	}
}

```

**参数说明：**

| **参数**			 | **说明**             |
|--------------------|----------------------|
| errcode 		 	 | 返回码               |
| errmsg    		 | 状态码对应的信息文本 |
| data     			 | 返回数据 			|
| $.data.id          | 表单id               |
| $.data.name        | 表单名称             |
| $.data.description | 描述                 |
| $.data.orderNo     | 排序号               |

### **获取表单详情**
----------
**请求方式：** GET 
**请求地址：** /api/designtime/applications/modules/forms/{formId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__evvfvKw6QFL8puXOiDK",
		"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.form/报表示例.form",
		"name": "报表示例",
		"type": 1,
		"showLog": false,
		"showType": "pc",
		"showWaterMark": false,
		"activities": [{
			"id": "__os2OpoFynecPfMhXy5P",
			"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.form/保存返回.activity/保存返回.activity",
			"name": "保存返回",
			"type": 11,
			"colorType": "default",
			"readonly": false,
			"startFlowScript": "\t\t\t\t\t\t\t",
			"editMode": 0,
			"flowShowType": "表单中显示流程操作",
			"orderno": 1,
			"parentForm": "__evvfvKw6QFL8puXOiDK",
			"impmappingconfigid": "4HhdfiaNeUM8utScH1j",
			"jumpType": 0,
			"expSub": false,
			"disableFlowNode": true,
			"changeFlowOperator": true,
			"changeFlowCc": true,
			"dispatcherMode": 0,
			"jumpMode": 0,
			"jumpActOpenType": 0,
			"withOld": false,
			"actionType": 0,
			"actionSelection": 0,
			"workFlowType": 0,
			"contextMenu": true,
			"showInToolbar": true,
			"transpond": "选择",
			"targetList": "11e6-53d0-13d83c16-81f5-679a826556ce|",
			"fieldErrorsAction": "/",
			"backAction": "/portal/dispatch/dynaform/document/content.jsp",
			"actionUrl": "/portal/dynaform/activity/handle.action",
			"afterAction": "/"
		}, {
			"id": "__3PejQj4gL95iicf4HEz",
			"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.form/打印模板.activity/打印模板.activity",
			"name": "打印模板",
			"type": 30,
			"onActionPrint": "__mXw1keqArTCt2UrAoie",
			"colorType": "default",
			"excelTemplate": "/uploads/exceltemplate/到达.xls",
			"readonly": false,
			"startFlowScript": "\t\t\t\t\t\t\t",
			"editMode": 0,
			"flowShowType": "表单中显示流程操作",
			"orderno": 2,
			"parentForm": "__evvfvKw6QFL8puXOiDK",
			"impmappingconfigid": "__6XGibM8vHvaKjA1XJeS",
			"jumpType": 0,
			"expSub": false,
			"disableFlowNode": true,
			"changeFlowOperator": true,
			"changeFlowCc": true,
			"dispatcherMode": 0,
			"jumpMode": 0,
			"jumpActOpenType": 0,
			"withOld": false,
			"actionType": 0,
			"actionSelection": 0,
			"workFlowType": 0,
			"contextMenu": true,
			"showInToolbar": true,
			"transpond": "选择",
			"targetList": "4mlBSmLGlzULUWJe8Nu|",
			"fieldErrorsAction": "/portal/share/report/flexprint.jsp",
			"backAction": "/portal/dispatch/dynaform/document/content.jsp",
			"actionUrl": "/portal/dynaform/activity/handle.action",
			"afterAction": "/portal/share/report/flexprint.jsp"
		}],
		"version": 1,
		"mappingStr": "{\"formName\":\"报表示例\",\"tableName\":\"\",\"columnMappings\":[]}",
		"checkout": false,
		"orderno": 0,
		"permissionType": "public",
		"layoutType": "horizontal",
		"typeName": "NORMALFORM",
		"allFieldNames": ["所属公司", "代收公司", "类型", "金额", "代收", "代付", "合计", "总合计"],
		"inited": true
	}
}

```

**参数说明：**

| **参数**                | **说明**               |
|-------------------------|------------------------|
| errcode                 | 返回码                 |
| errmsg                  | 状态码对应的信息文本   |
| data                    | 返回数据               |
| $.data.id               | 表单id                 |
| $.data.name             | 表单名称               |
| $.data.templatecontext  | 源代码文本             |
| $.data.discription 	  | 描述                   |
| $.data.type 			  | 类型                   |
| $.data.styleId          | 样式库id               |
| $.data.showLog          | 显示日志操作           |
| $.data.showWaterMark    | 是否显示水印           |
| $.data.waterMarkScript  | 水印脚本               |
| $.data.isopenablescript | 是否可打开脚本         |
| $.data.iseditablescript | 是否可编辑脚本         |
| $.data.mappingStr       | 映射表数据             |
| $.data.orderNo          | 排序号                 |
| $.data.permissionType   | 权限                   |
| $.data.layoutType       | 手机端表单控件布局样式 |

### **新建表单**
----------
**请求方式：** POST 
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/forms

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |

**请求包体：**

```
{
    "name": "name",
    "templatecontext": "templatecontext",
    "discription": "discription",
    "type": 1,
    "styleId": "styleId",
    "showLog": true,
    "showWaterMark": true,
    "waterMarkScript": "waterMarkScript",
    "isopenablescript": "isopenablescript",
    "iseditablescript": "iseditablescript",
    "mappingStr": "mappingStr",
    "orderno": 1,
    "permissionType": "permissionType",
    "layoutType": "layoutType"
}
```

**包体参数说明：**

| **参数**         | **说明**               |
|------------------|------------------------|
| name             | 表单名称               |
| templatecontext  | 源代码文本             |
| discription 	   | 描述                   |
| type 			   | 类型                   |
| styleId          | 样式库id               |
| showLog          | 显示日志操作           |
| showWaterMark    | 是否显示水印           |
| waterMarkScript  | 水印脚本               |
| isopenablescript | 是否可打开脚本         |
| iseditablescript | 是否可编辑脚本         |
| mappingStr       | 映射表数据             |
| orderNo          | 排序号                 |
| permissionType   | 权限                   |
| layoutType       | 手机端表单控件布局样式 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                | **说明**               |
|-------------------------|------------------------|
| errcode                 | 返回码                 |
| errmsg                  | 状态码对应的信息文本   |
| data                    | 返回数据               |
| $.data.id               | 表单id                 |

### **更新表单**
----------
**请求方式：** PUT 
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/forms/{formId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |

**请求包体：**

```
{
    "name": "name",
    "templatecontext": "templatecontext",
    "discription": "discription",
    "type": 1,
    "styleId": "styleId",
    "showLog": true,
    "showWaterMark": true,
    "waterMarkScript": "waterMarkScript",
    "isopenablescript": "isopenablescript",
    "iseditablescript": "iseditablescript",
    "mappingStr": "mappingStr",
    "orderNo": 1,
    "permissionType": "permissionType",
    "layoutType": "layoutType"
}
```

**包体参数说明：**

| **参数**         | **说明**               |
|------------------|------------------------|
| name             | 表单名称               |
| templatecontext  | 源代码文本             |
| discription 	   | 描述                   |
| type 			   | 类型                   |
| styleId          | 样式库id               |
| showLog          | 显示日志操作           |
| showWaterMark    | 是否显示水印           |
| waterMarkScript  | 水印脚本               |
| isopenablescript | 是否可打开脚本         |
| iseditablescript | 是否可编辑脚本         |
| mappingStr       | 映射表数据             |
| orderNo          | 排序号                 |
| permissionType   | 权限                   |
| layoutType       | 手机端表单控件布局样式 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除表单（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/modules/forms

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 表单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取字段列表**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/{formId}/fields?type={type}

**参数说明：**

| **参数** | **必须** | **说明**                                                    |
| -------- | -------- | ----------------------------------------------------------- |
| formId   | 是       | 表单id                                                      |
| type     | 否       | 字段类型（all,evenMapping[时间映射],dataMapping[数据映射]） |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "id",
            "name": "name",
            "type":"type"
        },...
    ]
}

```

**参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| errcode     | 返回码               |
| errmsg      | 状态码对应的信息文本 |
| data        | 返回数据             |
| $.data.id   | 字段id               |
| $.data.name | 字段名称             |

### **获取表单清除数据字段列表**

----------

**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/{formId}/clearFields

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| formId   | 是       | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "id",
            "name": "name",
            "type":"type"
        },...
    ]
}

```

**参数说明：**

| **参数**    | **说明**             |
| ----------- | -------------------- |
| errcode     | 返回码               |
| errmsg      | 状态码对应的信息文本 |
| data        | 返回数据             |
| $.data.id   | 字段id               |
| $.data.name | 字段名称             |

### **获取表单操作列表**

----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/{formId}/activitys

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "id",
            "name": "name",
        },...
    ]
}

```

**参数说明：**

| **参数**       | **说明**             |
|----------------|----------------------|
| errcode        | 返回码               |
| errmsg         | 状态码对应的信息文本 |
| data           | 返回数据             |
| $.data.id      | 操作id               |
| $.data.name    | 操作名称             |
| $.data.orderNo | 排序号               |

### **获取表单操作详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/activitys/{activityId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |
| activityId    |    是    | 操作id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__SXjLwO29yiIqFclTPJQ",
		"name": "保存",
		"type": 11,
		"colorType": "default",
		"readonly": false,
		"startFlowScript": "\t\t\t\t\t\t\t",
		"editMode": 0,
		"flowShowType": "表单中显示流程操作",
		"orderno": 1,
		"parentForm": "__TgWsX7ZgvsGGcigQULd",
		"jumpType": 0,
		"expSub": false,
		"disableFlowNode": true,
		"changeFlowOperator": true,
		"changeFlowCc": true,
		"dispatcherMode": 0,
		"jumpMode": 0,
		"jumpActOpenType": 0,
		"withOld": false,
		"actionType": 0,
		"actionSelection": 0,
		"workFlowType": 0,
		"contextMenu": true,
		"showInToolbar": true,
		"transpond": "选择",
		"targetList": "11e7-6614-49736da0-9cdb-af6bc8266ed2|",
		"fieldErrorsAction": "/",
		"backAction": "/portal/dispatch/dynaform/document/content.jsp",
		"actionUrl": "/portal/dynaform/activity/handle.action",
		"afterAction": "/"
	}
}
```

**参数说明：**

| **参数** 						   | **说明**                         		   |
|----------------------------------|-------------------------------------------|
| errcode 						   | 返回码                         	       |
| errmsg  						   | 状态码对应的信息文本      		           |
| data     						   | 返回数据         						   |
| $.data.id    					   | 操作id            						   |
| $.data.name					   | 操作名称      						       |
| $.data.type                      | 动作类型        						   |
| $.data.onActionForm              | 关联的表单         		  			   |
| $.data.onActionView              | 关联的视图                 			   |
| $.data.onActionFlow              | 关联的流程                 			   |
| $.data.onActionPrint			   | 关联的动态打印             		       |
| $.data.colorType                 | 颜色类型          						   |
| $.data.beforeActionScript        | 动作执行前脚本   						   |
| $.data.afterActionScript         | 动作执行后脚本   						   |
| $.data.hiddenScript              | 隐藏脚本        						   |
| $.data.readonlyScript            | 只读脚本       						   |
| $.data.startFlowScript           | 流程启动脚本    						   |
| $.data.editMode                  | 编辑方式         						   |
| $.data.flowShowType              | 流程操作显示方式            		       |
| $.data.fileNameScript            | 文件路径脚本     						   |
| $.data.orderNo          		   | 排序号           						   |
| $.data.stateToShow        	   | 状态标签         						   |
| $.data.parentView        		   | 关联的视图标识         				   |
| $.data.parentForm         	   | 关联的表单标识          				   |
| $.data.impmappingconfigid        | 关联的导入配置映射标识                    |
| $.data.jumpType        		   | 跳转类型       						   |
| $.data.expSub         		   | 是否导入子表数据               		   |
| $.data.icon         			   | 图标地址            					   |
| $.data.disableFlowNode           | 禁止添加和删除流程节点       			   |
| $.data.changeFlowOperator        | 仅允许修改流程节点操作人        		   |
| $.data.changeFlowCc              | 仅允许修改流程抄送人         			   |
| $.data.multiLanguageLabel        | 多语言标签           					   |
| $.data.dispatcherMode        	   | Dispatcher的模式       				   |
| $.data.dispatcherUrl        	   | Dispatcher的Url        				   |
| $.data.dispatcherParams          | Dispatcher的参数        				   |
| $.data.jumpMode         		   | 跳转按钮模式         					   |
| $.data.jumpActOpenType           | 跳转按钮打开类型    					   |
| $.data.withOld                   | 是否带旧数据         					   |
| $.data.actionDispatcherUrlScript | 自定义按钮 执行后的跳转动作类型的地址脚本 |
| $.data.actionSelection           | 自定义按钮 执行动作类型                   |
| $.data.relatedFormId             | 自定义按钮 关联表单id      			   |
| $.data.actionScript              | 自定义按钮 动作执行脚本    		       |
| $.data.workFlowType              | 流程类型         						   |
| $.data.contextMenu               | 右键菜单操作     					       |
| $.data.showInToolbar             | 在工具栏中显示        					   |
| $.data.transpond                 | 转发操作         						   |
| $.data.targetList                | 目标清单        						   |
| $.data.actionType                | 自定义按钮 执行后的操作类型       		   |

### **新建表单操作**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/forms/{formId}/activitys

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |

**请求包体：**

```
{
    "name": "name",
    "type": "type",
    "onActionForm": "onActionForm",
    "onActionView": "onActionView",
    "onActionFlow": "onActionFlow",
    "onActionPrint": "onActionPrint",
    "colorType": "colorType",
    "beforeActionScript": "beforeActionScript",
    "afterActionScript": "afterActionScript",
    "hiddenScript": "hiddenScript",
    "readonlyScript": "readonlyScript",
    "startFlowScript": "startFlowScript",
    "editMode": "editMode",
    "flowShowType": "flowShowType",
    "fileNameScript": "fileNameScript",
    "orderNo": "orderNo",
    "stateToShow": "stateToShow",
    "parentView": "parentView",
    "parentForm": "parentForm",
    "impmappingconfigid": "impmappingconfigid",
    "jumpType": "jumpType",
    "expSub": "expSub",
    "icon": "icon",
    "disableFlowNode": "disableFlowNode",
    "changeFlowOperator": "changeFlowOperator",
    "changeFlowCc": "changeFlowCc",
    "multiLanguageLabel": "multiLanguageLabel",
    "dispatcherMode": "dispatcherMode",
    "dispatcherUrl": "dispatcherUrl",
    "dispatcherParams": "dispatcherParams",
    "jumpMode": "jumpMode",
    "jumpActOpenType": "jumpActOpenType",
    "withOld": "withOld",
    "actionDispatcherUrlScript": "actionDispatcherUrlScript",
    "actionSelection": "actionSelection",
    "relatedFormId": "relatedFormId",
    "actionScript": "actionScript",
    "workFlowType": "workFlowType",
    "contextMenu": "contextMenu",
    "showInToolbar": "showInToolbar",
    "transpond": "transpond",
    "targetList": "targetList",
    "actionType": "actionType"
}
```

**包体参数说明：**

| **参数** 					| **说明**                         		    |
|---------------------------|-------------------------------------------|
| name					    | 操作名称      						    |
| type                      | 动作类型        						    |
| onActionForm              | 关联的表单         		  			    |
| onActionView              | 关联的视图                 			    |
| onActionFlow              | 关联的流程                 			    |
| onActionPrint			    | 关联的动态打印             		        |
| colorType                 | 颜色类型          					    |
| beforeActionScript        | 动作执行前脚本   						    |
| afterActionScript         | 动作执行后脚本   						    |
| hiddenScript              | 隐藏脚本        						    |
| readonlyScript            | 只读脚本       						    |
| startFlowScript           | 流程启动脚本    						    |
| editMode                  | 编辑方式         						    |
| flowShowType              | 流程操作显示方式            		        |
| fileNameScript            | 文件路径脚本     						    |
| orderNo          		    | 排序号           						    |
| stateToShow        	    | 状态标签         						    |
| parentView        		| 关联的视图标识         				    |
| parentForm         	    | 关联的表单标识          				    |
| impmappingconfigid        | 关联的导入配置映射标识                    |
| jumpType        		    | 跳转类型       						    |
| expSub         		    | 是否导入子表数据               		    |
| icon         			    | 图标地址            					    |
| disableFlowNode           | 禁止添加和删除流程节点       			    |
| changeFlowOperator        | 仅允许修改流程节点操作人        		    |
| changeFlowCc              | 仅允许修改流程抄送人         			    |
| multiLanguageLabel        | 多语言标签           					    |
| dispatcherMode        	| Dispatcher的模式       	 			    |
| dispatcherUrl        	    | Dispatcher的Url        	   			    |
| dispatcherParams          | Dispatcher的参数        				    |
| jumpMode         		    | 跳转按钮模式         					    |
| jumpActOpenType           | 跳转按钮打开类型    					    |
| withOld                   | 是否带旧数据         					    |
| actionDispatcherUrlScript | 自定义按钮 执行后的跳转动作类型的地址脚本 |
| actionSelection           | 自定义按钮 执行动作类型                   |
| relatedFormId             | 自定义按钮 关联表单id      			    |
| actionScript              | 自定义按钮 动作执行脚本    		        |
| workFlowType              | 流程类型         						    |
| contextMenu               | 右键菜单操作     					        |
| showInToolbar             | 在工具栏中显示        					|
| transpond                 | 转发操作         						    |
| targetList                | 目标清单        						    |
| actionType                | 自定义按钮 执行后的操作类型       	    |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数** 						   | **说明**                         		   |
|----------------------------------|-------------------------------------------|
| errcode 						   | 返回码                         	       |
| errmsg  						   | 状态码对应的信息文本      		           |
| data     						   | 返回数据         						   |
| $.data.id    					   | 操作id            						   |

### **更新表单操作**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/{applicationId}/modules/forms/{formId}/activitys/{activityId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |
| activityId    |    是    | 按钮id   |

**请求包体：**

```
{
    "name": "name",
    "type": "type",
    "onActionForm": "onActionForm",
    "onActionView": "onActionView",
    "onActionFlow": "onActionFlow",
    "onActionPrint": "onActionPrint",
    "colorType": "colorType",
    "beforeActionScript": "beforeActionScript",
    "afterActionScript": "afterActionScript",
    "hiddenScript": "hiddenScript",
    "readonlyScript": "readonlyScript",
    "startFlowScript": "startFlowScript",
    "editMode": "editMode",
    "flowShowType": "flowShowType",
    "fileNameScript": "fileNameScript",
    "orderNo": "orderNo",
    "stateToShow": "stateToShow",
    "parentView": "parentView",
    "parentForm": "parentForm",
    "impmappingconfigid": "impmappingconfigid",
    "jumpType": "jumpType",
    "expSub": "expSub",
    "icon": "icon",
    "disableFlowNode": "disableFlowNode",
    "changeFlowOperator": "changeFlowOperator",
    "changeFlowCc": "changeFlowCc",
    "multiLanguageLabel": "multiLanguageLabel",
    "dispatcherMode": "dispatcherMode",
    "dispatcherUrl": "dispatcherUrl",
    "dispatcherParams": "dispatcherParams",
    "jumpMode": "jumpMode",
    "jumpActOpenType": "jumpActOpenType",
    "withOld": "withOld",
    "actionDispatcherUrlScript": "actionDispatcherUrlScript",
    "actionSelection": "actionSelection",
    "relatedFormId": "relatedFormId",
    "actionScript": "actionScript",
    "workFlowType": "workFlowType",
    "contextMenu": "contextMenu",
    "showInToolbar": "showInToolbar",
    "transpond": "transpond",
    "targetList": "targetList",
    "actionType": "actionType"
}
```

**包体参数说明：**

| **参数** 					| **说明**                         		    |
|---------------------------|-------------------------------------------|
| name					    | 操作名称      						    |
| type                      | 动作类型        						    |
| onActionForm              | 关联的表单         		  			    |
| onActionView              | 关联的视图                 			    |
| onActionFlow              | 关联的流程                 			    |
| onActionPrint			    | 关联的动态打印             		        |
| colorType                 | 颜色类型          					    |
| beforeActionScript        | 动作执行前脚本   						    |
| afterActionScript         | 动作执行后脚本   						    |
| hiddenScript              | 隐藏脚本        						    |
| readonlyScript            | 只读脚本       						    |
| startFlowScript           | 流程启动脚本    						    |
| editMode                  | 编辑方式         						    |
| flowShowType              | 流程操作显示方式            		        |
| fileNameScript            | 文件路径脚本     						    |
| orderNo          		    | 排序号           						    |
| stateToShow        	    | 状态标签         						    |
| parentView        		| 关联的视图标识         				    |
| parentForm         	    | 关联的表单标识          				    |
| impmappingconfigid        | 关联的导入配置映射标识                    |
| jumpType        		    | 跳转类型       						    |
| expSub         		    | 是否导入子表数据               		    |
| icon         			    | 图标地址            					    |
| disableFlowNode           | 禁止添加和删除流程节点       			    |
| changeFlowOperator        | 仅允许修改流程节点操作人        		    |
| changeFlowCc              | 仅允许修改流程抄送人         			    |
| multiLanguageLabel        | 多语言标签           					    |
| dispatcherMode        	| Dispatcher的模式       	 			    |
| dispatcherUrl        	    | Dispatcher的Url        	   			    |
| dispatcherParams          | Dispatcher的参数        				    |
| jumpMode         		    | 跳转按钮模式         					    |
| jumpActOpenType           | 跳转按钮打开类型    					    |
| withOld                   | 是否带旧数据         					    |
| actionDispatcherUrlScript | 自定义按钮 执行后的跳转动作类型的地址脚本 |
| actionSelection           | 自定义按钮 执行动作类型                   |
| relatedFormId             | 自定义按钮 关联表单id      			    |
| actionScript              | 自定义按钮 动作执行脚本    		        |
| workFlowType              | 流程类型         						    |
| contextMenu               | 右键菜单操作     					        |
| showInToolbar             | 在工具栏中显示        					|
| transpond                 | 转发操作         						    |
| targetList                | 目标清单        						    |
| actionType                | 自定义按钮 执行后的操作类型       	    |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除表单操作（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/modules/forms/activitys

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 操作id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **重置字段编号(返回随机数)**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/getSequence

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "__K7d6QgG3FN0aLpTP6c9"
}

```

### **清除表单字段数据**

------

**请求方式：** POST
**请求地址：** /api/designtime/applications/modules/forms/cleardata?formId={formId}

**参数说明：**

| **参数** | **必须** | **说明**           |
| -------- | -------- | ------------------ |
| formId   | 是       | 表单id             |
| fields   | 是       | 请求包体(字段名称) |

**请求包体：**

```
["field1","field2"]
```

**包体参数说明：**

| **参数**                  | **说明**                                  |
| ------------------------- | ----------------------------------------- |
| fields                    | 字段名称                                  |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

### **表单帮助接口**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/help?id={id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 帮助id   |

**请求包体：**

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"href": "application/application_module_form_info_advance_help.html",
		"label": "Form_Info_Advance_Help"
	}
}
```

### 帮助接口树形结构

**请求方式：** GET  
**请求地址：** /api/designtime/applications/modules/getHelpTreeIndex

**请求包体：**

```

```

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "html"
}
```

**参数说明：**

| **参数** | **说明**                 |      |
| -------- | ------------------------ | ---- |
| errcode  | 返回码（0=成功，1=失败） |      |
| errmsg   | 对返回码的文本描述内容   |      |

### 获取数据表名称映射

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/dataBaseTableMap?applicationId={applicationId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| applicationId       | 是       | 软件id   |

**请求包体：**

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"": "选择",
		"kms_authorization": "kms_authorization",
		"kms_category": "kms_category",
		"kms_disk": "kms_disk",
		"kms_edit_file": "kms_edit_file",
		"库存表": "库存表"
	}
}
```

### **获取数据库列名称映射**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/forms/dataBaseColumnMap?applicationId={applicationId}&tableName={tableName}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| applicationId       | 是       | 软件id   |
| tableName       | 是       | 数据表名  |

**请求包体：**

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"": "选择",
		"ID": "ID",
		"名称": "名称",
		"单价": "单价",
		"库存": "库存",
		"备注": "备注"
	}
}

```

### **映射表单同步数据**

------

**请求方式：** POST
**请求地址：** /api/designtime/applications/modules/forms/synchronouslyData?formId={formId}&tableName={tableName}&domainId={domainId}

**参数说明：**

| **参数**  | **必须** | **说明** |
| --------- | -------- | -------- |
| formId    | 是       | 表单id   |
| tableName | 是       | 数据表名 |
| domainId  | 是       | 企业域id |

**请求包体：**

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "数据同步成功"
}

```

## 5.  **摘要（Summarys）**

----------
### **获取表单摘要列表**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/summarys?formId={formId}&pageNo={pageNo}&linesPerPage={linesPerPage}&scope={scope}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| formId        | 否       | 表单id   |
| scope         | 否       | 表单类型 |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 8,
		"data": [{
			"id": "__ARDGaHaysmhswgS4vee",
			"name": "短信分享",
			"type": "00",
			"title": "短信分享",
			"uri": "/4.0功能示例.application/接口测试.module/请假测试.module/自由流程测试.form/短信分享.summary/短信分享.summary",
			"fieldNames": "备注",
			"summaryScript": "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t",
			"scope": 1,
			"formId": "__xTeazT2hYRCoxwLzEpn",
			"formName": "自由流程测试"
		}, {
			"id": "__4FNqiUuyxffhYKCTGuv",
			"name": "请假申请通知",
			"type": "01",
			"title": "请假申请通知",
			"uri": "/4.0功能示例.application/流程示例.module/流程类型.module/串行流程.form/请假申请通知.summary/请假申请通知.summary",
			"fieldNames": "请假天数;备注;$FormName",
			"summaryScript": "    (function(){                    \n            var str = \"\";                                               \n                var curDoc = getCurrentDocument();                                               \n                  var user=curDoc.getAuthor();                                         \n                  var username=curDoc.getAuthor().getName();                                        \n                  var depid = user.getDefaultDepartment();                                                                                                        \n                  var deptProcess=getDepartmentProcess();                                                                                                        \n                  var dept = deptProcess.doView(depid);                                               \n                  var deptname=dept.getName();                                               \n                  str  =\"&nbsp;标题: \"+getItemValue(\"流程标题\");                                     \n                  str +=\"&nbsp;&nbsp;&nbsp;&nbsp;申请人: \"+username;                                             \n                  str +=\"&nbsp;&nbsp;&nbsp;&nbsp;部门: \"+deptname;                                            \n                return str;          \n       })()  ",
			"scope": 1,
			"formId": "9c0aqDXwpcfHP2G5wCv",
			"formName": "串行流程"
		}]
	}
}
```

**参数说明：**

| **参数** 			   | **说明**             |
|----------------------|----------------------|
| errcode  			   | 返回码               |
| errmsg   			   | 状态码对应的信息文本 |
| data    		       | 返回数据  			  |
| $.data.id            | 摘要id               |
| $.data.name          | 摘要名称         	  |
| $.data.title         | 摘要标题             |
| $.data.type          | 摘要类型(脚本、设计) |
| $.data.scope | 作用域(1:流程通知、分享,6:流程抄送,0:待办摘要) |

### **获取表单摘要详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/summarys/{summaryId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| formId        |    是    | 表单id   |
| summaryId     |    是    | 摘要id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__ARDGaHaysmhswgS4vee",
		"name": "短信分享",
		"title": "短信分享",
		"type": "00",
		"formId": "__xTeazT2hYRCoxwLzEpn",
		"fieldNames": "备注",
		"summaryScript": "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t",
		"scope": 1,
		"orderby": "LASTMODIFIED"
	}
}

```

**参数说明：**

| **参数** 			   | **说明**             |
|----------------------|----------------------|
| errcode  			   | 返回码               |
| errmsg   			   | 状态码对应的信息文本 |
| data    		       | 返回数据  			  |
| $.data.id            | 摘要id               |
| $.data.name          | 摘要名称         	  |
| $.data.title         | 摘要标题             |
| $.data.type          | 摘要类型             |
| $.data.formId        | 关联表单的ID         |
| $.data.fieldNames    | 摘要字段             |
| $.data.summaryScript | 摘要脚本             |
| $.data.scope         | 作用域         	  |

### **新建表单摘要**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/summarys

**请求包体：**

```
{
    "parentId":"parentId",
    "applicationid":"applicationid",
    "title": "title",
    "type": "type",
    "formId": "formId",
    "fieldNames": "fieldNames",
    "summaryScript": "summaryScript",
    "scope": "scope"
}
```

**包体参数说明：**

| **参数** 		| **说明**     |
|---------------|--------------|
| name          | 摘要名称     |
| title         | 摘要标题     |
| type          | 摘要类型     |
| formId        | 关联表单的ID |
| fieldNames    | 摘要字段     |
| summaryScript | 摘要脚本     |
| scope         | 作用域       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数** 			   | **说明**             |
|----------------------|----------------------|
| errcode  			   | 返回码               |
| errmsg   			   | 状态码对应的信息文本 |
| data    		       | 返回数据  			  |
| $.data.id            | 摘要id               |

### **更新表单摘要**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/summarys

**请求包体：**

```
{
	"id": "id",
    "name": "name",
    "parentId":"parentId",
    "applicationid":"applicationid",
    "title": "title",
    "type": "type",
    "formId": "formId",
    "fieldNames": "fieldNames",
    "summaryScript": "summaryScript",
    "scope": "scope"
}
```

**包体参数说明：**

| **参数** 		| **说明**     |
|---------------|--------------|
| name          | 摘要名称     |
| title         | 摘要标题     |
| type          | 摘要类型     |
| formId        | 关联表单的ID |
| fieldNames    | 摘要字段     |
| summaryScript | 摘要脚本     |
| scope         | 作用域       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除表单摘要（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/summarys

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 摘要id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 6.  **视图（Views）**
### **获取视图列表（可根据名字或者描述查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/{moduleId}/views?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}&filterType={filterType}

**参数说明：**

| **参数**      | **必须** | **说明** 		  |
|---------------|----------|------------------|
| moduleId 		|    是    | 模块id  		  |
| searchword 	|    否    | 查询名称或者描述 |
| filterType | 否 | 过滤的视图类型(用“,”分隔) |
| pageNo | 否 | 当前页数 |
| linesPerPage | 否      | 每页行数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "id",
            "name": "name",
            "description": "description"
        },...
    ]
}

```

**参数说明：**

| **参数**                     | **说明**                         |
|------------------------------|----------------------------------|
| errcode                      | 返回码                           |
| errmsg                       | 状态码对应的信息文本             |
| data                         | 返回数据 						  |
| $.data.id                    | 视图id          				  |
| $.data.name                  | 视图名称          				  |
| $.data.description           | 描述          					  |

### **获取视图详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/views/{viewId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__LzvbwJGuzjepcTM3ygs",
		"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.view/报表示例.view",
		"name": "报表示例",
		"pagination": true,
		"pageLines": "10",
		"showTotalRow": true,
		"refresh": false,
		"newPage": false,
		"readonly": false,
		"relatedMap": "                                                        ",
		"displayType": "relatedForm",
		"showWaterMark": false,
		"searchFormId": "__dqCe49NWqPCop9buOe0",
		"searchForm": {
			"id": "__dqCe49NWqPCop9buOe0",
			"uri": "/4.0功能示例.application/报表.module/报表示例.module/test.form/test.form",
			"name": "test",
			"sortId": "159376945821800000",
			"type": 256,
			"showLog": false,
			"showWaterMark": false,
			"version": 0,
			"mappingStr": "{\"formName\":\"test\",\"tableName\":\"\",\"columnMappings\":[]}",
			"checkout": false,
			"orderno": 0,
			"permissionType": "public",
			"layoutType": "horizontal",
			"typeName": "SEARCHFORM",
			"allFieldNames": ["单行文本框1", "单行文本框2"],
			"inited": true
		},
		"editAble": true,
		"readAble": true,
		"columns": [{
			"id": "__4zVtMZFmuIQjxwOfzzL",
			"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.view/所属公司.column/所属公司.column",
			"name": "所属公司",
			"parentView": "__LzvbwJGuzjepcTM3ygs",
			"type": "COLUMN_TYPE_FIELD",
			"formid": "__evvfvKw6QFL8puXOiDK",
			"fieldName": "所属公司",
			"flowReturnCss": false,
			"orderno": 0,
			"sum": false,
			"total": false,
			"isOrderByField": "false",
			"clickSorting": true,
			"thouSign": false,
			"color": "000000",
			"fontSize": "12",
			"groundColor": "FFFFFF",
			"showIcon": false,
			"visible": true,
			"visible4ExpExcel": true,
			"visible4Print": true,
			"visible4PagePrint": true,
			"showType": "01",
			"displayType": "00",
			"displayLength": "-1",
			"showTitle": true,
			"hiddenColumn": false
		}],
		"relatedForm": "__evvfvKw6QFL8puXOiDK",
		"permissionType": "public",
		"filterCondition": "[{field:'总合计',operator:'LIKE',type:'03',match:'单行文本框1'}]",
		"commonFilterCondition": "[]",
		"openType": 1,
		"activities": [{
			"id": "__fBlmrwVX7YpqDDd0z9k",
			"uri": "/4.0功能示例.application/报表.module/报表示例.module/报表示例.view/新建.activity/新建.activity",
			"name": "新建",
			"type": 2,
			"onActionForm": "__evvfvKw6QFL8puXOiDK",
			"readonly": false,
			"editMode": 0,
			"orderno": 0,
			"parentView": "__LzvbwJGuzjepcTM3ygs",
			"jumpType": 0,
			"expSub": false,
			"disableFlowNode": false,
			"changeFlowOperator": false,
			"changeFlowCc": false,
			"dispatcherMode": 0,
			"jumpMode": 0,
			"jumpActOpenType": 0,
			"withOld": false,
			"actionType": 0,
			"actionSelection": 0,
			"workFlowType": 0,
			"contextMenu": false,
			"showInToolbar": true,
			"fieldErrorsAction": "/portal/dispatch/dynaform/document/content.jsp",
			"parentFullName": "报表示例",
			"backAction": "/portal/dynaform/view/displayView.action?isCloseDialog=true",
			"actionUrl": "/portal/dynaform/activity/handle.action?_formid=__evvfvKw6QFL8puXOiDK",
			"afterAction": "/portal/dispatch/dynaform/document/content.jsp"
		}],
		"editMode": "00",
		"intValue": 1,
		"fullName": "报表示例",
		"sum": false,
		"simpleClassName": "ListView",
		"clickSortingFieldArr": ["ITEM_所属公司 ASC", "ITEM_代收公司 ASC", "ITEM_类型 ASC", "ITEM_金额 ASC", "ITEM_代收 ASC", "ITEM_代付 ASC", "ITEM_合计 ASC", "ITEM_总合计 ASC"]
	}
}

```

**参数说明：**

| **参数**                     | **说明**                         |
|------------------------------|----------------------------------|
| errcode                      | 返回码                           |
| errmsg                       | 状态码对应的信息文本             |
| data                         | 返回数据 						  |
| $.data.id                    | 视图id          				  |
| $.data.name                  | 视图名称          				  |
| $.data.description           | 描述          					  |
| $.data.pagination            | 是否分页         				  |
| $.data.linesPerPage          | 每页显示记录         			  |
| $.data.showTotalRow          | 是否显示总计数         		  |
| $.data.refresh               | 是否刷新          				  |
| $.data.readonly              | 是否只读          				  |
| $.data.relatedMap            | 视图列映射       			      |
| $.data.displayType           | 数据呈现类型                     |
| $.data.showWaterMark         | 显示水印                         |
| $.data.waterMarkScript       | 水印脚本                         |
| $.data.searchFormId          | 查询表单id                       |
| $.data.styleId          	   | 样式库id                         |
| $.data.relatedForm           | 关联表单                         |
| $.data.templateForm          | 模板表单                         |
| $.data.permissionType        | 授权方式                         |
| $.data.filterScript          | 过滤脚本(编辑模式为Dql模式)      |
| $.data.sqlFilterScript       | 过滤脚本(编辑模式为Sql模式)      |
| $.data.procedureFilterScript | 过滤脚本(编辑模式为存储过程模式) |
| $.data.filterCondition       | 过滤条件(编辑模式为设计模式)     |
| $.data.commonFilterCondition | 常用过滤条件          	          |
| $.data.authorityCondition    | 权限过滤条件          			  |
| $.data.openType              | 打开类型                         |
| $.data.editMode              | 编辑模式                         |

### **复制视图**
----------
**请求方式：** POST 
**请求地址：** /api/designtime/applications/modules/views/copy

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |
**请求包体：**

```
[
	id,id
]
```

**包体参数说明：**

| **参数**              | **说明**                		   |
|-----------------------|----------------------------------|
| name                  | 视图名称          			   |
| description           | 描述          				   |
| pagination            | 是否分页         				   |
| linesPerPage          | 每页显示记录         			   |
| showTotalRow          | 是否显示总计数         		   |
| refresh               | 是否刷新          			   |
| readonly              | 是否只读          			   |
| relatedMap            | 视图列映射       			       |
| displayType           | 数据呈现类型                     |
| showWaterMark         | 显示水印                         |
| waterMarkScript       | 水印脚本                         |
| searchFormId          | 查询表单id                       |
| styleId          	    | 样式库id                         |
| relatedForm           | 关联表单                         |
| templateForm          | 模板表单                         |
| permissionType        | 授权方式                         |
| filterScript          | 过滤脚本(编辑模式为Dql模式)      |
| sqlFilterScript       | 过滤脚本(编辑模式为Sql模式)      |
| procedureFilterScript | 过滤脚本(编辑模式为存储过程模式) |
| filterCondition       | 过滤条件(编辑模式为设计模式)     |
| commonFilterCondition | 常用过滤条件          	       |
| authorityCondition    | 权限过滤条件          		   |
| openType              | 打开类型                         |
| editMode              | 编辑模式                         |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **新建视图**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/views?viewType={viewType}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| moduleId      | 是       | 模块id   |
| viewType      | 是       | 视图类型 |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "pagination": true,
    "linesPerPage": 10,
    "showTotalRow": true,
    "refresh": true,
    "readonly": true,
    "relatedMap": "relatedMap",
    "displayType": "displayType",
    "showWaterMark": true,
    "waterMarkScript": "waterMarkScript",
    "searchFormId": "searchFormId",
    "styleId": "styleId",
    "relatedForm": "relatedForm",
    "templateForm": "templateForm",
    "permissionType": "permissionType",
    "filterScript": "filterScript",
    "sqlFilterScript": "sqlFilterScript",
    "procedureFilterScript": "procedureFilterScript",
    "filterCondition": "filterCondition",
    "commonFilterCondition": "commonFilterCondition",
    "authorityCondition": "authorityCondition",
    "openType": "openType",
    "editMode": "editMode"
}
```

**包体参数说明：**

| **参数**              | **说明**                		   |
|-----------------------|----------------------------------|
| name                  | 视图名称          			   |
| description           | 描述          				   |
| pagination            | 是否分页         				   |
| linesPerPage          | 每页显示记录         			   |
| showTotalRow          | 是否显示总计数         		   |
| refresh               | 是否刷新          			   |
| readonly              | 是否只读          			   |
| relatedMap            | 视图列映射       			       |
| displayType           | 数据呈现类型                     |
| showWaterMark         | 显示水印                         |
| waterMarkScript       | 水印脚本                         |
| searchFormId          | 查询表单id                       |
| styleId          	    | 样式库id                         |
| relatedForm           | 关联表单                         |
| templateForm          | 模板表单                         |
| permissionType        | 授权方式                         |
| filterScript          | 过滤脚本(编辑模式为Dql模式)      |
| sqlFilterScript       | 过滤脚本(编辑模式为Sql模式)      |
| procedureFilterScript | 过滤脚本(编辑模式为存储过程模式) |
| filterCondition       | 过滤条件(编辑模式为设计模式)     |
| commonFilterCondition | 常用过滤条件          	       |
| authorityCondition    | 权限过滤条件          		   |
| openType              | 打开类型                         |
| editMode              | 编辑模式                         |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                     | **说明**                         |
|------------------------------|----------------------------------|
| errcode                      | 返回码                           |
| errmsg                       | 状态码对应的信息文本             |
| data                         | 返回数据 						  |
| $.data.id                    | 视图id          				  |

### **更新视图**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/views/{viewId}?viewType={viewType}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| moduleId      | 是       | 模块id   |
| viewId        | 是       | 视图id   |
| viewType      | 是       | 视图类型 |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "pagination": true,
    "linesPerPage": 10,
    "showTotalRow": true,
    "refresh": true,
    "readonly": true,
    "relatedMap": "relatedMap",
    "displayType": "displayType",
    "showWaterMark": true,
    "waterMarkScript": "waterMarkScript",
    "searchFormId": "searchFormId",
    "styleId": "styleId",
    "relatedForm": "relatedForm",
    "templateForm": "templateForm",
    "permissionType": "permissionType",
    "filterScript": "filterScript",
    "sqlFilterScript": "sqlFilterScript",
    "procedureFilterScript": "procedureFilterScript",
    "filterCondition": "filterCondition",
    "commonFilterCondition": "commonFilterCondition",
    "authorityCondition": "authorityCondition",
    "openType": "openType",
    "editMode": "editMode"
}
```

**包体参数说明：**

| **参数**              | **说明**                		   |
|-----------------------|----------------------------------|
| name                  | 视图名称          			   |
| description           | 描述          				   |
| pagination            | 是否分页         				   |
| linesPerPage          | 每页显示记录         			   |
| showTotalRow          | 是否显示总计数         		   |
| refresh               | 是否刷新          			   |
| readonly              | 是否只读          			   |
| relatedMap            | 视图列映射       			       |
| displayType           | 数据呈现类型                     |
| showWaterMark         | 显示水印                         |
| waterMarkScript       | 水印脚本                         |
| searchFormId          | 查询表单id                       |
| styleId          	    | 样式库id                         |
| relatedForm           | 关联表单                         |
| templateForm          | 模板表单                         |
| permissionType        | 授权方式                         |
| filterScript          | 过滤脚本(编辑模式为Dql模式)      |
| sqlFilterScript       | 过滤脚本(编辑模式为Sql模式)      |
| procedureFilterScript | 过滤脚本(编辑模式为存储过程模式) |
| filterCondition       | 过滤条件(编辑模式为设计模式)     |
| commonFilterCondition | 常用过滤条件          	       |
| authorityCondition    | 权限过滤条件          		   |
| openType              | 打开类型                         |
| editMode              | 编辑模式                         |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "description": "description",
        "pagination": true,
        "linesPerPage": 10,
        "showTotalRow": true,
        "refresh": true,
        "readonly": true,
        "relatedMap": "relatedMap",
        "displayType": "displayType",
        "showWaterMark": true,
        "waterMarkScript": "waterMarkScript",
        "searchFormId": "searchFormId",
        "styleId": "styleId",
        "relatedForm": "relatedForm",
        "templateForm": "templateForm",
        "permissionType": "permissionType",
        "filterScript": "filterScript",
        "sqlFilterScript": "sqlFilterScript",
        "procedureFilterScript": "procedureFilterScript",
        "filterCondition": "filterCondition",
        "commonFilterCondition": "commonFilterCondition",
        "authorityCondition": "authorityCondition",
        "openType": "openType",
        "editMode": "editMode"
    }
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除视图（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/modules/views

**请求包体：**

```
[
    "id1",
    "id2"
]
```

| **参数** | **说明** |
|----------|----------|
| id       | 视图id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **一键生成视图**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/modules/views?formId={formid}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| formId   | 是       | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取视图列列表**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/views/{viewId}/columns

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "id",
            "name": "name",
            "orderNo": "orderNo"
        },...
    ]
}

```

**参数说明：**

| **参数**                  | **说明**                  |
|---------------------------|---------------------------|
| errcode                   | 返回码                    |
| errmsg                    | 状态码对应的信息文本      |
| data                      | 返回数据                  |
| $.data.id                 | 视图列id                  |
| $.data.name               | 视图列名称                |
| $.data.orderNo            | 排序号                    |

### **获取视图列详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/views/columns/{columnId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |
| columnId      |    是    | 列id     |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data":{
        "id": "id",
        "name": "name",
        "parentView": "parentView",
        "valueScript": "valueScript",
        "hiddenScript": "hiddenScript",
        "type": "type",
        "formid": "formid",
        "fieldName": "fieldName",
        "fieldId": "fieldId"
        "flowReturnCss": "flowReturnCss",
        "imageName": "imageName",
        "fontColor": "fontColor",
        "orderNo": "orderNo",
        "sum": "sum",
        "total": "total",
        "isOrderByField": "isOrderByField",
        "multiLanguageLabel": "multiLanguageLabel",
        "actionScript": "actionScript",
        "clickSorting": "clickSorting",
        "jumpMapping": "jumpMapping",
        "mappingform": "mappingform",
        "formatType": "formatType",
        "decimalsNum": "decimalsNum",
        "thouSign": "thouSign",
        "decimalsCurr": "decimalsCurr",
        "currType": "currType",
        "color": "color",
        "fontSize": "fontSize",
        "groundColor": "groundColor",
        "showIcon": "showIcon",
        "iconMapping": "iconMapping",
        "visible": "visible",
        "visible4ExpExcel": "visible4ExpExcel",
        "visible4Print": "visible4Print",
        "visible4PagePrint": "visible4PagePrint",
        "showType": "showType",
        "displayType": "displayType",
        "displayLength": "displayLength",
        "showTitle": "showTitle"
    }
}

```

**参数说明：**

| **参数**                  | **说明**                  |
|---------------------------|---------------------------|
| errcode                   | 返回码                    |
| errmsg                    | 状态码对应的信息文本      |
| data                      | 返回数据                  |
| $.data.id                 | 视图列id                  |
| $.data.name               | 视图列名称                |
| $.data.parentView         | 所属视图id                |
| $.data.valueScript        | 值脚本                    |
| $.data.hiddenScript       | 隐藏脚本                  |
| $.data.type               | 类型（COLUMN_TYPE_FIELD） |
| $.data.formid             | 关联表单id                |
| $.data.fieldName          | 关联表单的字段名称        |
| $.data.fieldId            | 关联表单的字段id          |
| $.data.flowReturnCss      | 需要回退时增加样式        |
| $.data.imageName          | 回退的时候在前面的images  |
| $.data.fontColor          | 显示的字体                |
| $.data.orderNo            | 排序号                    |
| $.data.sum                | 当前页小计                |
| $.data.total              | 跨页总计                  |
| $.data.isOrderByField     | 默认排序                  |
| $.data.multiLanguageLabel | 多语言标签                |
| $.data.actionScript 	    |操作执行脚本               |
| $.data.clickSorting       | 单击列头排序              |
| $.data.jumpMapping        | 操作列跳转类型的映射配置  |
| $.data.mappingform        | 跳转类型的目标表单ID      |
| $.data.formatType         | 列的格式的类型            |
| $.data.decimalsNum        | 数值的小数位数            |
| $.data.thouSign           | 千位分隔符                |
| $.data.decimalsCurr       | 货币类型的小数位数        |
| $.data.currType           | 货币类型                  |
| $.data.color              | 字体颜色                  |
| $.data.fontSize           | 字体大小                  |
| $.data.groundColor        | 底色                      |
| $.data.showIcon           | 以图标显示                |
| $.data.iconMapping        | 以图标显示的映射关系      |
| $.data.visible            | 视图列表时可见            |
| $.data.visible4ExpExcel   | 导出Excel时可见           |
| $.data.visible4Print      | 自定义打印时可见          |
| $.data.visible4PagePrint  | 网页打印时可见            |
| $.data.showType           | 字段值显示类型            |
| $.data.displayType        | 显示方式                  |
| $.data.displayLength      | 显示内容的长度            |
| $.data.showTitle          | 是否显示title             |

### **新建视图列**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/views/{viewId}/columns

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |

**请求包体：**

```
{
    "name": "name",
    "parentView": "parentView",
    "valueScript": "valueScript",
    "hiddenScript": "hiddenScript",
    "type": "type",
    "formid": "formid",
    "fieldName": "fieldName",
    "fieldId": "fieldId"
    "flowReturnCss": "flowReturnCss",
    "imageName": "imageName",
    "fontColor": "fontColor",
    "orderNo": "orderNo",
    "sum": "sum",
    "total": "total",
    "isOrderByField": "isOrderByField",
    "multiLanguageLabel": "multiLanguageLabel",
    "actionScript": "actionScript",
    "clickSorting": "clickSorting",
    "jumpMapping": "jumpMapping",
    "mappingform": "mappingform",
    "formatType": "formatType",
    "decimalsNum": "decimalsNum",
    "thouSign": "thouSign",
    "decimalsCurr": "decimalsCurr",
    "currType": "currType",
    "color": "color",
    "fontSize": "fontSize",
    "groundColor": "groundColor",
    "showIcon": "showIcon",
    "iconMapping": "iconMapping",
    "visible": "visible",
    "visible4ExpExcel": "visible4ExpExcel",
    "visible4Print": "visible4Print",
    "visible4PagePrint": "visible4PagePrint",
    "showType": "showType",
    "displayType": "displayType",
    "displayLength": "displayLength",
    "showTitle": "showTitle"
}
```

**包体参数说明：**

| **参数**           | **说明**                  |
|--------------------|---------------------------|
| name               | 视图列名称                |
| parentView         | 所属视图id                |
| valueScript        | 值脚本                    |
| hiddenScript       | 隐藏脚本                  |
| type               | 类型（COLUMN_TYPE_FIELD） |
| formid             | 关联表单id                |
| fieldName          | 关联表单的字段名称        |
| fieldId            | 关联表单的字段id          |
| flowReturnCss      | 需要回退时增加样式        |
| imageName          | 回退的时候在前面的images  |
| fontColor          | 显示的字体                |
| orderNo            | 排序号                    |
| sum                | 当前页小计                |
| total              | 跨页总计                  |
| isOrderByField     | 默认排序                  |
| multiLanguageLabel | 多语言标签                |
| actionScript 	     |操作执行脚本               |
| clickSorting       | 单击列头排序              |
| jumpMapping        | 操作列跳转类型的映射配置  |
| mappingform        | 跳转类型的目标表单ID      |
| formatType         | 列的格式的类型            |
| decimalsNum        | 数值的小数位数            |
| thouSign           | 千位分隔符                |
| decimalsCurr       | 货币类型的小数位数        |
| currType           | 货币类型                  |
| color              | 字体颜色                  |
| fontSize           | 字体大小                  |
| groundColor        | 底色                      |
| showIcon           | 以图标显示                |
| iconMapping        | 以图标显示的映射关系      |
| visible            | 视图列表时可见            |
| visible4ExpExcel   | 导出Excel时可见           |
| visible4Print      | 自定义打印时可见          |
| visible4PagePrint  | 网页打印时可见            |
| showType           | 字段值显示类型            |
| displayType        | 显示方式                  |
| displayLength      | 显示内容的长度            |
| showTitle          | 是否显示title             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                  | **说明**                  |
|---------------------------|---------------------------|
| errcode                   | 返回码                    |
| errmsg                    | 状态码对应的信息文本      |
| data                      | 返回数据                  |
| $.data.id                 | 视图列id                  |

### **批量新建视图列**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/views/{viewId}/columns/batch

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |

**请求包体：**

```
[
	{
        "name": "name",
        "parentView": "parentView",
        "valueScript": "valueScript",
        "hiddenScript": "hiddenScript",
        "type": "type",
        "formid": "formid",
        "fieldName": "fieldName",
        "fieldId": "fieldId"
        "flowReturnCss": "flowReturnCss",
        "imageName": "imageName",
        "fontColor": "fontColor",
        "orderNo": "orderNo",
        "sum": "sum",
        "total": "total",
        "isOrderByField": "isOrderByField",
        "multiLanguageLabel": "multiLanguageLabel",
        "actionScript": "actionScript",
        "clickSorting": "clickSorting",
        "jumpMapping": "jumpMapping",
        "mappingform": "mappingform",
        "formatType": "formatType",
        "decimalsNum": "decimalsNum",
        "thouSign": "thouSign",
        "decimalsCurr": "decimalsCurr",
        "currType": "currType",
        "color": "color",
        "fontSize": "fontSize",
        "groundColor": "groundColor",
        "showIcon": "showIcon",
        "iconMapping": "iconMapping",
        "visible": "visible",
        "visible4ExpExcel": "visible4ExpExcel",
        "visible4Print": "visible4Print",
        "visible4PagePrint": "visible4PagePrint",
        "showType": "showType",
        "displayType": "displayType",
        "displayLength": "displayLength",
        "showTitle": "showTitle"
	},...
]
```

**包体参数说明：**

| **参数**           | **说明**                  |
|--------------------|---------------------------|
| name               | 视图列名称                |
| parentView         | 所属视图id                |
| valueScript        | 值脚本                    |
| hiddenScript       | 隐藏脚本                  |
| type               | 类型（COLUMN_TYPE_FIELD） |
| formid             | 关联表单id                |
| fieldName          | 关联表单的字段名称        |
| fieldId            | 关联表单的字段id          |
| flowReturnCss      | 需要回退时增加样式        |
| imageName          | 回退的时候在前面的images  |
| fontColor          | 显示的字体                |
| orderNo            | 排序号                    |
| sum                | 当前页小计                |
| total              | 跨页总计                  |
| isOrderByField     | 默认排序                  |
| multiLanguageLabel | 多语言标签                |
| actionScript 	     |操作执行脚本               |
| clickSorting       | 单击列头排序              |
| jumpMapping        | 操作列跳转类型的映射配置  |
| mappingform        | 跳转类型的目标表单ID      |
| formatType         | 列的格式的类型            |
| decimalsNum        | 数值的小数位数            |
| thouSign           | 千位分隔符                |
| decimalsCurr       | 货币类型的小数位数        |
| currType           | 货币类型                  |
| color              | 字体颜色                  |
| fontSize           | 字体大小                  |
| groundColor        | 底色                      |
| showIcon           | 以图标显示                |
| iconMapping        | 以图标显示的映射关系      |
| visible            | 视图列表时可见            |
| visible4ExpExcel   | 导出Excel时可见           |
| visible4Print      | 自定义打印时可见          |
| visible4PagePrint  | 网页打印时可见            |
| showType           | 字段值显示类型            |
| displayType        | 显示方式                  |
| displayLength      | 显示内容的长度            |
| showTitle          | 是否显示title             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        "id1": "id1",
        "id2": "id2",...
	]
}

```

**参数说明：**

| **参数**                  | **说明**                  |
|---------------------------|---------------------------|
| errcode                   | 返回码                    |
| errmsg                    | 状态码对应的信息文本      |
| data                      | 返回数据                  |
| $.data.id                 | 视图列id                  |

### **更新视图列**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/{applicationId}/modules/views/{viewId}/columns/{columnId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |
| columnId      |    是    | 视图列id |

**请求包体：**

```
{
    "name": "name",
    "parentView": "parentView",
    "valueScript": "valueScript",
    "hiddenScript": "hiddenScript",
    "type": "type",
    "formid": "formid",
    "fieldName": "fieldName",
    "fieldId": "fieldId"
    "flowReturnCss": "flowReturnCss",
    "imageName": "imageName",
    "fontColor": "fontColor",
    "orderNo": "orderNo",
    "sum": "sum",
    "total": "total",
    "isOrderByField": "isOrderByField",
    "multiLanguageLabel": "multiLanguageLabel",
    "actionScript": "actionScript",
    "clickSorting": "clickSorting",
    "jumpMapping": "jumpMapping",
    "mappingform": "mappingform",
    "formatType": "formatType",
    "decimalsNum": "decimalsNum",
    "thouSign": "thouSign",
    "decimalsCurr": "decimalsCurr",
    "currType": "currType",
    "color": "color",
    "fontSize": "fontSize",
    "groundColor": "groundColor",
    "showIcon": "showIcon",
    "iconMapping": "iconMapping",
    "visible": "visible",
    "visible4ExpExcel": "visible4ExpExcel",
    "visible4Print": "visible4Print",
    "visible4PagePrint": "visible4PagePrint",
    "showType": "showType",
    "displayType": "displayType",
    "displayLength": "displayLength",
    "showTitle": "showTitle"
}
```

**包体参数说明：**

| **参数**           | **说明**                  |
|--------------------|---------------------------|
| name               | 视图列名称                |
| parentView         | 所属视图id                |
| valueScript        | 值脚本                    |
| hiddenScript       | 隐藏脚本                  |
| type               | 类型（COLUMN_TYPE_FIELD） |
| formid             | 关联表单id                |
| fieldName          | 关联表单的字段名称        |
| fieldId            | 关联表单的字段id          |
| flowReturnCss      | 需要回退时增加样式        |
| imageName          | 回退的时候在前面的images  |
| fontColor          | 显示的字体                |
| orderNo            | 排序号                    |
| sum                | 当前页小计                |
| total              | 跨页总计                  |
| isOrderByField     | 默认排序                  |
| multiLanguageLabel | 多语言标签                |
| actionScript 	     |操作执行脚本               |
| clickSorting       | 单击列头排序              |
| jumpMapping        | 操作列跳转类型的映射配置  |
| mappingform        | 跳转类型的目标表单ID      |
| formatType         | 列的格式的类型            |
| decimalsNum        | 数值的小数位数            |
| thouSign           | 千位分隔符                |
| decimalsCurr       | 货币类型的小数位数        |
| currType           | 货币类型                  |
| color              | 字体颜色                  |
| fontSize           | 字体大小                  |
| groundColor        | 底色                      |
| showIcon           | 以图标显示                |
| iconMapping        | 以图标显示的映射关系      |
| visible            | 视图列表时可见            |
| visible4ExpExcel   | 导出Excel时可见           |
| visible4Print      | 自定义打印时可见          |
| visible4PagePrint  | 网页打印时可见            |
| showType           | 字段值显示类型            |
| displayType        | 显示方式                  |
| displayLength      | 显示内容的长度            |
| showTitle          | 是否显示title             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除视图列（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/modules/views/columns

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 列id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取视图操作列表**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/views/{viewId}/activitys

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    否    | 视图id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"id": "__V7lH4kPXR2ilZvkpkKy",
		"name": "新建",
		"type": 2,
		"onActionForm": "__TgWsX7ZgvsGGcigQULd",
		"readonly": false,
		"editMode": 0,
		"orderno": 0,
		"parentView": "__79xYtYYaC1Q9IALgkLi",
		"jumpType": 0,
		"expSub": false,
		"disableFlowNode": false,
		"changeFlowOperator": false,
		"changeFlowCc": false,
		"dispatcherMode": 0,
		"jumpMode": 0,
		"jumpActOpenType": 0,
		"withOld": false,
		"actionType": 0,
		"actionSelection": 0,
		"workFlowType": 0,
		"contextMenu": false,
		"showInToolbar": true,
		"fieldErrorsAction": "/portal/dispatch/dynaform/document/content.jsp",
		"parentFullName": "表单",
		"backAction": "/portal/dynaform/view/displayView.action?isCloseDialog=true",
		"actionUrl": "/portal/dynaform/activity/handle.action?_formid=__TgWsX7ZgvsGGcigQULd",
		"afterAction": "/portal/dispatch/dynaform/document/content.jsp"
	}, {
		"id": "__otqx59gNMrIdauAqXsQ",
		"name": "删除",
		"type": 3,
		"readonly": false,
		"editMode": 0,
		"orderno": 1,
		"parentView": "__79xYtYYaC1Q9IALgkLi",
		"jumpType": 0,
		"expSub": false,
		"disableFlowNode": false,
		"changeFlowOperator": false,
		"changeFlowCc": false,
		"dispatcherMode": 0,
		"jumpMode": 0,
		"jumpActOpenType": 0,
		"withOld": false,
		"actionType": 0,
		"actionSelection": 0,
		"workFlowType": 0,
		"contextMenu": false,
		"showInToolbar": true,
		"fieldErrorsAction": "/portal/dynaform/view/displayView.action",
		"parentFullName": "表单",
		"backAction": "/portal/dynaform/view/displayView.action",
		"actionUrl": "/portal/dynaform/activity/handle.action",
		"afterAction": "/portal/dynaform/view/displayView.action"
	}]
}
```

**参数说明：**

| **参数**       | **说明**             |
|----------------|----------------------|
| errcode        | 返回码               |
| errmsg         | 状态码对应的信息文本 |
| data           | 返回数据             |
| $.data.id      | 操作id               |
| $.data.name    | 操作名称             |
| $.data.orderNo | 排序号               |

### **获取视图操作详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/views/activitys/{activityId}

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId |    是    | 软件id     |
| moduleId      |    是    | 模块id     |
| viewId        |    是    | 视图id     |
| activityId    |    是    | 视图操作id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__V7lH4kPXR2ilZvkpkKy",
		"name": "新建",
		"type": 2,
		"onActionForm": "__TgWsX7ZgvsGGcigQULd",
		"readonly": false,
		"editMode": 0,
		"orderno": 0,
		"parentView": "__79xYtYYaC1Q9IALgkLi",
		"jumpType": 0,
		"expSub": false,
		"disableFlowNode": false,
		"changeFlowOperator": false,
		"changeFlowCc": false,
		"dispatcherMode": 0,
		"jumpMode": 0,
		"jumpActOpenType": 0,
		"withOld": false,
		"actionType": 0,
		"actionSelection": 0,
		"workFlowType": 0,
		"contextMenu": false,
		"showInToolbar": true,
		"backAction": "/portal/dynaform/view/displayView.action?isCloseDialog=true",
		"actionUrl": "/portal/dynaform/activity/handle.action?_formid=__TgWsX7ZgvsGGcigQULd",
		"afterAction": "/portal/dispatch/dynaform/document/content.jsp",
		"fieldErrorsAction": "/portal/dispatch/dynaform/document/content.jsp",
		"parentFullName": "表单"
	}
}

```

**参数说明：**

| **参数** 						   | **说明**                         		   |
|----------------------------------|-------------------------------------------|
| errcode 						   | 返回码                         	       |
| errmsg  						   | 状态码对应的信息文本      		           |
| data     						   | 返回数据         						   |
| $.data.id    					   | 操作id            						   |
| $.data.name					   | 操作名称      						       |
| $.data.parentView        		   | 所属视图id         			     	   |
| $.data.type                      | 动作类型        						   |
| $.data.beforeActionScript        | 动作执行前脚本   						   |
| $.data.afterActionScript         | 动作执行后脚本   						   |
| $.data.hiddenScript              | 隐藏脚本        						   |
| $.data.readonlyScript            | 只读脚本       						   |
| $.data.editMode                  | 编辑方式         						   |
| $.data.orderNo          		   | 排序号           						   |
| $.data.jumpType        		   | 跳转类型       						   |
| $.data.expSub         		   | 是否导入子表数据               		   |
| $.data.icon         			   | 图标地址            					   |
| $.data.disableFlowNode           | 禁止添加和删除流程节点       			   |
| $.data.changeFlowOperator        | 仅允许修改流程节点操作人        		   |
| $.data.changeFlowCc              | 仅允许修改流程抄送人         			   |
| $.data.multiLanguageLabel        | 多语言标签           					   |
| $.data.dispatcherMode        	   | Dispatcher的模式       				   |
| $.data.dispatcherUrl        	   | Dispatcher的Url        				   |
| $.data.dispatcherParams          | Dispatcher的参数        				   |
| $.data.jumpMode         		   | 跳转按钮模式         					   |
| $.data.jumpActOpenType           | 跳转按钮打开类型    					   |
| $.data.withOld                   | 是否带旧数据         					   |
| $.data.workFlowType              | 流程类型         						   |
| $.data.contextMenu               | 右键菜单操作     					       |
| $.data.showInToolbar             | 在工具栏中显示        					   |

### **新建视图操作**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/views/{viewId}/activitys

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| viewId        |    是    | 视图id   |

**请求包体：**

```
{
    "name": "name",
    "parentView": "parentView",
    "type": "type",
    "beforeActionScript": "beforeActionScript",
    "afterActionScript": "afterActionScript",
    "hiddenScript": "hiddenScript",
    "readonlyScript": "readonlyScript",
    "editMode": "editMode",
    "orderNo": "orderNo",
    "jumpType": "jumpType",
    "expSub": "expSub",
    "disableFlowNode": "disableFlowNode",
    "changeFlowOperator": "changeFlowOperator",
    "changeFlowCc": "changeFlowCc",
    "multiLanguageLabel": "multiLanguageLabel",
    "dispatcherMode": "dispatcherMode",
    "dispatcherUrl": "dispatcherUrl",
    "dispatcherParams": "dispatcherParams",
    "jumpMode": "jumpMode",
    "jumpActOpenType": "jumpActOpenType",
    "withOld": "withOld",
    "actionType": "actionType",
    "actionSelection": "actionSelection",
    "workFlowType": "workFlowType",
    "contextMenu": "contextMenu",
    "showInToolbar": "showInToolbar"
}
```

**包体参数说明：**

| **参数** 			        | **说明**                         		   |
|---------------------------|------------------------------------------|
| name					    | 操作名称      						   |
| parentView        	    | 所属视图id         			     	   |
| type                      | 动作类型        						   |
| beforeActionScript        | 动作执行前脚本   						   |
| afterActionScript         | 动作执行后脚本   						   |
| hiddenScript              | 隐藏脚本        						   |
| readonlyScript            | 只读脚本       						   |
| editMode                  | 编辑方式         						   |
| orderNo          		    | 排序号           						   |
| jumpType        		    | 跳转类型       						   |
| expSub         		    | 是否导入子表数据               		   |
| icon         			    | 图标地址            					   |
| disableFlowNode           | 禁止添加和删除流程节点       			   |
| changeFlowOperator        | 仅允许修改流程节点操作人        		   |
| changeFlowCc              | 仅允许修改流程抄送人         			   |
| multiLanguageLabel        | 多语言标签           					   |
| dispatcherMode        	| Dispatcher的模式       				   |
| dispatcherUrl        	    | Dispatcher的Url        				   |
| dispatcherParams          | Dispatcher的参数        				   |
| jumpMode         		    | 跳转按钮模式         					   |
| jumpActOpenType           | 跳转按钮打开类型    					   |
| withOld                   | 是否带旧数据         					   |
| workFlowType              | 流程类型         						   |
| contextMenu               | 右键菜单操作     					       |
| showInToolbar             | 在工具栏中显示        				   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数** 						   | **说明**                         		   |
|----------------------------------|-------------------------------------------|
| errcode 						   | 返回码                         	       |
| errmsg  						   | 状态码对应的信息文本      		           |
| data     						   | 返回数据         						   |
| $.data.id    					   | 操作id            						   |

### **更新视图操作**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/{applicationId}/modules/views/{viewId}/activitys/{activityId}

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId |    是    | 软件id     |
| moduleId      |    是    | 模块id     |
| viewId        |    是    | 视图id     |
| activityId    |    是    | 视图操作id |

**请求包体：**

```
{
    "name": "name",
    "parentView": "parentView",
    "type": "type",
    "beforeActionScript": "beforeActionScript",
    "afterActionScript": "afterActionScript",
    "hiddenScript": "hiddenScript",
    "readonlyScript": "readonlyScript",
    "editMode": "editMode",
    "orderNo": "orderNo",
    "jumpType": "jumpType",
    "expSub": "expSub",
    "disableFlowNode": "disableFlowNode",
    "changeFlowOperator": "changeFlowOperator",
    "changeFlowCc": "changeFlowCc",
    "multiLanguageLabel": "multiLanguageLabel",
    "dispatcherMode": "dispatcherMode",
    "dispatcherUrl": "dispatcherUrl",
    "dispatcherParams": "dispatcherParams",
    "jumpMode": "jumpMode",
    "jumpActOpenType": "jumpActOpenType",
    "withOld": "withOld",
    "actionType": "actionType",
    "actionSelection": "actionSelection",
    "workFlowType": "workFlowType",
    "contextMenu": "contextMenu",
    "showInToolbar": "showInToolbar"
}
```

**包体参数说明：**

| **参数** 			        | **说明**                         		   |
|---------------------------|------------------------------------------|
| name					    | 操作名称      						   |
| parentView        	    | 所属视图id         			     	   |
| type                      | 动作类型        						   |
| beforeActionScript        | 动作执行前脚本   						   |
| afterActionScript         | 动作执行后脚本   						   |
| hiddenScript              | 隐藏脚本        						   |
| readonlyScript            | 只读脚本       						   |
| editMode                  | 编辑方式         						   |
| orderNo          		    | 排序号           						   |
| jumpType        		    | 跳转类型       						   |
| expSub         		    | 是否导入子表数据               		   |
| icon         			    | 图标地址            					   |
| disableFlowNode           | 禁止添加和删除流程节点       			   |
| changeFlowOperator        | 仅允许修改流程节点操作人        		   |
| changeFlowCc              | 仅允许修改流程抄送人         			   |
| multiLanguageLabel        | 多语言标签           					   |
| dispatcherMode        	| Dispatcher的模式       				   |
| dispatcherUrl        	    | Dispatcher的Url        				   |
| dispatcherParams          | Dispatcher的参数        				   |
| jumpMode         		    | 跳转按钮模式         					   |
| jumpActOpenType           | 跳转按钮打开类型    					   |
| withOld                   | 是否带旧数据         					   |
| workFlowType              | 流程类型         						   |
| contextMenu               | 右键菜单操作     					       |
| showInToolbar             | 在工具栏中显示        				   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除视图操作（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/modules/views/activitys

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 操作id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取数据来源表单字段（包含系统变量）**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/getFormValueStoreFields/{formId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| formId   | 是       | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"": "选择",
		"姓名": "姓名",
		"入职时间": "入职时间",
		"个人照片": "个人照片",
		"部门选择框": "部门选择框",
		"职务": "职务",
		"毕业学校": "毕业学校",
		"最高学历": "最高学历",
		"在校荣誉": "在校荣誉",
		"备注": "备注",
		"$Id": "$表单ID",
		"$StateLabel": "$表单状态标签",
		"$Created": "$表单创建时间",
		"$AuditDate": "$表单审批日期",
		"$LastModified": "$表单最后修改时间",
		"$Author": "$表单作者",
		"$AuditorNames": "$表单审批人名称",
		"$LastFlowOperation": "$表单最后流程操作",
		"$FormName": "$表单名称"
	}
}

```

### **视图获取系统筛选字段**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/getSystemScreeningFields/{formId}

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| formId   | 是       | 数据来源表单id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		" ": " ",
		"author": "作者",
		"authorDefaultDept": "作者默认部门",
		"auditor": "审批人",
		"processed": "处理过",
		"departmentField_部门选择框": "部门选择框"
	}
}

```

### 根据筛选字段获取作用域

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/getScopeByField/{authField}

**参数说明：**

| **参数**  | **必须** | **说明**         |
| --------- | -------- | ---------------- |
| authField | 是       | 选中的筛选字段值 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"itself": "自己",
		"superior": "直属上级用户",
		"allSuperior": "所有上级用户",
		"lower": "直属下级用户",
		"allLower": "所有下级用户"
	}
}

```

 

### 视图列排序修改

------

**请求方式：** PUT
**请求地址：** /api/designtime/applications/views/column/order?oId={oId}&nId={nId}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| oId      | 是       | 选中的列id |
| nId      | 是       | 互换的列id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "修改成功"
}
```

### 操作列表排序修改

------

**请求方式：** PUT
**请求地址：** /api/designtime/applications/activity/order?oId={oId}&nId={nId}

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| oId      | 是       | 选中操作按钮id |
| nId      | 是       | 互换操作按钮id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "修改成功"
}
```



## 7. **流程（Workflows）**

### **获取流程列表（可根据名字查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/{moduleId}/workflows?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| moduleId      | 是       | 模块id   |
| name          | 否       | 查询名称 |
| pageNo        | 否·      | 页码     |
| linesPerPage  | 否       | 页长度   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "id",
            "name": "name"
        },...
    ]
}

```

**参数说明：**

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.id         | 流程id               |
| $.data.name       | 流程名称             |

### **获取流程详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/workflows/{flowId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| flowId        |    是    | 流程id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "authorname": "authorname",
        "lastmodify": "lastmodify",
        "subject": "subject",
        "flow": "flow"
    }
}

```

**参数说明：**

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.id         | 流程id               |
| $.data.name       | 流程名称             |
| $.data.authorname | 创建人id             |
| $.data.lastmodify | 最后更新时间         |
| $.data.subject    | 流程主题             |
| $.data.flow       | 流程源代码           |

### **复制流程**
----------
**请求方式：** POST 
**请求地址：** /api/designtime/applications/modules/workflows/copy

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| Id       | 是       | 流程id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数**   | **说明**             |
|------------|----------------------|
| name       | 流程名称             |
| authorname | 创建人id             |
| lastmodify | 最后更新时间         |
| subject    | 流程主题             |
| flow       | 流程源代码           |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **新建流程**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/workflows

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |

**请求包体：**

```
{
    "name": "name",
    "subject": "subject",
    "flow": "flow"
}
```

**包体参数说明：**

| **参数**   | **说明**             |
|------------|----------------------|
| name       | 流程名称             |
| authorname | 创建人id             |
| lastmodify | 最后更新时间         |
| subject    | 流程主题             |
| flow       | 流程源代码           |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.id         | 流程id               |

### **更新流程**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/modules/workflows/{flowId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| moduleId | 是       | 模块id   |
| flowId   | 是       | 流程id   |

**请求包体：**

```
{
    "name": "name",
    "authorname": "authorname",
    "lastmodify": "lastmodify",
    "subject": "subject",
    "flow": "flow"，
    "parentId":"parentId",
    "applicationid":"applicationid"
}
```

**包体参数说明：**

| **参数**   | **说明**             |
|------------|----------------------|
| name       | 流程名称             |
| authorname | 创建人id             |
| lastmodify | 最后更新时间         |
| subject    | 流程主题             |
| flow       | 流程源代码           |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除流程（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/modules/workflows

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 流程id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取可回退节点列表**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/workflows/{flowId}/nodes?type={type}&nodeId={nodeId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |
| flowId        |    是    | 流程id   |
| nodeId        |    否    | 节点id   |
| type          |    否    | 类型     |

**请求包体：**

**包体参数说明：**

| **参数**   | **说明**             |
|------------|----------------------|
| name       | 流程名称             |
| authorname | 创建人id             |
| lastmodify | 最后更新时间         |
| subject    | 流程主题             |
| flow       | 流程源代码           |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "nodeid": "nodeid",
            "nodename": "nodename"
        },...
    ]
}

```

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.nodeid     | 可回退节点id         |
| $.data.nodename   | 可回退节点名称       |

### **流程编辑器子流程获取父流程表单**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/modules/workflows/flexGetForms?formName={formName}&moduleName={moduleName}&pageNo={pageNo}

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| pageNo        | 否       | 页码     |
| formName      | 否       | 表单名称 |
| moduleName    | 否       | 模块名称 |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 1,
		"data": [{
			"id": "__3hgJK72PUZrQCame6LT",
			"formName": "包含元素_主表",
			"moduleName": "包含元素",
			"formFields": [{
				"valuetype": "",
				"name": "--select--"
			}, {
				"valuetype": "VALUE_TYPE_VARCHAR",
				"name": "申请人"
			}, {
				"valuetype": "VALUE_TYPE_VARCHAR",
				"name": "备注"
			}, {
				"valuetype": "",
				"name": "包含元素"
			}]
		}]
	}
}

```

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

### **流程编辑器获取所有流程**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/modules/workflows/flexGetBillDefiVOs?flowName={flowName}&moduleName={moduleName}&pageNo={pageNo}

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| pageNo        | 否       | 页码     |
| flowName      | 否       | 流程名称 |
| moduleName    | 否       | 模块名称 |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 1,
		"data": [{
			"id": "__qy2QvZYl8cSTsoJjS2c",
			"flowName": "主子流程",
			"moduleName": "请假测试"
		}],
		"modulearray": ["", "请假测试", "视图类型"]
	}
}

```

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

## 8. **统计图（Charts）**

### **获取统计图列表（可根据名字或者备注查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/{moduleId}/charts?searchword={searchword}

**参数说明：**

| **参数**   | **必须** | **说明**         |
| ---------- | -------- | ---------------- |
| moduleId   | 是       | 模块id           |
| searchword | 否       | 查询名称或者备注 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 1,
		"data": [ {
			"id": "__wVsmajCTcp6zkzZOI1j",
			"name": "单元测试666",
			"note": "备注"
		}]
	}
}

```

**参数说明：**

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.id         | 统计图id             |
| $.data.name       | 统计图名称           |
| $.data.note       | 备注                 |

### **获取统计图详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/charts/{chartId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| chartId  | 是       | 统计图id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "type": "type",
        "note": "note",
        "scripttext": "scripttext"
    }
}

```

**参数说明：**

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.id         | 统计图id             |
| $.data.name       | 统计图名称           |
| $.data.type       | 类型                 |
| $.data.note       | 备注                 |
| $.data.scripttext | 脚本文本             |
| $.data.chartName  | 样例名称             |

### **新建统计图**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/charts

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |

**请求包体：**

```
{
    "name": "name",
    "type": "type",
    "note": "note",
    "viewId":"viewId",
    "scripttext": "scripttext"
}
```

**包体参数说明：**

| **参数**   | **说明**             |
|------------|----------------------|
| name       | 统计图名称           |
| type       | 类型                 |
| note       | 备注                 |
| scripttext | 脚本文本             |
| chartName  | 样例名称             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**          | **说明**             |
|-------------------|----------------------|
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.id         | 统计图id             |

### **更新统计图**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/charts

**参数说明：**

**请求包体：**

```
{
	"applicationid": "sOZu9kthmxyP8qQfq0e",
	"parentId": "__jdnS7aKT9LklWZGoZgD",
	"name": "单元测试666",
	"scripttext": "123456789",
	"viewId": "",
	"note": "备注",
	"id": "id"
}
```

**包体参数说明：**

| **参数**   | **说明**             |
|------------|----------------------|
| name       | 统计图名称           |
| type       | 类型                 |
| note       | 备注                 |
| scripttext | 脚本文本             |
| chartName  | 样例名称             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除统计图（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/charts

**参数说明：**

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明**   |
|----------|------------|
| id       | 统计图id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 9. **报表（Reports）**
### **获取报表列表（可根据名字或者描述查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/modules/{moduleId}/reports?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}&isPrint={isPrint}

**参数说明：**

| **参数**      | **必须** | **说明**           |
|---------------|----------|--------------------|
| applicationId |    是    | 软件id             |
| moduleId      |    是    | 模块id             |
| searchword    |    否    | 查询名称或者描述   |
| isPrint | 否 | 获取打印模板列表(参数为1) |
| pageNo      | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 8,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [ {
			"id": "__jp7imGkVI5wSVEX27q7",
			"uri": "/4.0功能示例.application/报表.module/报表示例.module/子报表.report/子报表.report",
			"name": "子报表",
			"description": "",
			"scriptTemplate": "",
			"xmlTemplate": "",
			"dataSourceType": "DATASOURCE_TYPE_SQL",
			"dataSourceSearchForm": "__evvfvKw6QFL8puXOiDK",
			"dataSourceView": null,
			"dataSourceSqlConnectDs": null,
			"dataSourceSqlScript": "(function(){  \n   var sql = \"select * from tlk_报表示例\";  \n   return sql;  \n     \n   })()",
			"dataSourceCustomScript": "",
			"jrxmlFilePath": "/workspace/4.0功能示例.application/报表.module/报表示例.module/子报表.report/子报表.jrxml",
			"dataSourceName": "4.0功能示例",
			"isDefaultStyle": "0",
			"reportColumnInfos": null,
			"jrxmlString": null,
			"viewId": "__LzvbwJGuzjepcTM3ygs",
			"domainId": null,
			"reportExampleName": "",
			"procedureScript": "",
			"reportSql": null,
			"subReportId": "",
			"formId": "",
			"isPrint": 0,
			"templateType": "JRXML",
			"drdataSource": null
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**           | **说明**                 |
| ------------------ | ------------------------ |
| errcode            | 返回码                   |
| errmsg             | 状态码对应的信息文本     |
| data               | 返回数据                 |
| $.data.id          | 报表id                   |
| $.data.name        | 报表名称                 |
| $.data.description | 描述                     |
| $.data.isPrint     | 是否打印模板(0=否，1=是) |

### **获取报表详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/reports/{reportId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| reportId      | 是       | 报表id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "description": "description",
        "scriptTemplate": "scriptTemplate",
        "xmlTemplate": "xmlTemplate",
        "dataSourceType": "dataSourceType",
        "dataSourceSearchForm": "dataSourceSearchForm",
        "dataSourceSqlScript": "dataSourceSqlScript",
        "dataSourceCustomScript": "dataSourceCustomScript",
        "jrxmlFilePath": "jrxmlFilePath",
        "dataSourceName": "dataSourceName",
        "isDefaultStyle": 0,
        "viewId": "viewId",
        "reportExampleName": "reportExampleName",
        "procedureScript": "procedureScript",
        "templateType": "templateType"
    }
}

```

**参数说明：**

| **参数**                      | **说明**             |
|-------------------------------|----------------------|
| errcode                       | 返回码               |
| errmsg                        | 状态码对应的信息文本 |
| data                          | 返回数据             |
| $.data.id                     | 报表id               |
| $.data.name                   | 报表名称             |
| $.data.description            | 描述                 |
| $.data.scriptTemplate         | 模板脚本             |
| $.data.xmlTemplate            | 模板xml              |
| $.data.dataSourceType         | 数据源类型           |
| $.data.dataSourceSearchForm   | 数据源查询表单       |
| $.data.dataSourceSqlScript    | 数据源sql脚本        |
| $.data.dataSourceCustomScript | 自定义数据源脚本     |
| $.data.jrxmlFilePath          | jrxml文件路径地址    |
| $.data.dataSourceName         | 数据源名称           |
| $.data.isDefaultStyle         | 默认样例             |
| $.data.viewId                 | 关联视图id           |
| $.data.reportExampleName      | 样例名称             |
| $.data.procedureScript        | 存储过程数据源脚本   |
| $.data.templateType           | 模板类型             |


### **新建报表**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/reports

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| moduleId      |    是    | 模块id   |

**请求包体：**

```
{
	"name": "报表名称",
	"dataSourceName": "选择数据源名称",
	"dataSourceType": "数据源类型",
	"viewId": "视图数据源的视图",
	"formId": "打印选的表单",
	"dataSourceSqlScript": "sql数据源框",
	"procedureScript": "存储过程数据源框",
	"dataSourceCustomScript": "自定义数据源框",
	"templateType": "内容页面的类型 设计或者脚本",
	"jrxmlString": "报表的jrxml字符串",
	"isDefaultStyle": "是否默认使用默认样例",
	"jrxmlFilePath": "jrxml文件路径",
	"subReportId": "子报表id",
	"dataSourceSearchForm": "数据源查询表单",
	"description": "备注",
	"isPrint": 0 是否打印模板
}
```

**包体参数说明：**

| **参数**               | **说明**             |
|------------------------|----------------------|
| name                   | 报表名称             |
| description            | 描述                 |
| scriptTemplate         | 模板脚本             |
| xmlTemplate            | 模板xml              |
| dataSourceType         | 数据源类型           |
| dataSourceSearchForm   | 数据源查询表单       |
| dataSourceSqlScript    | 数据源sql脚本        |
| dataSourceCustomScript | 自定义数据源脚本     |
| jrxmlFilePath          | jrxml文件路径地址    |
| dataSourceName         | 数据源名称           |
| isDefaultStyle         | 默认样例             |
| viewId                 | 关联视图id           |
| reportExampleName      | 样例名称             |
| procedureScript        | 存储过程数据源脚本   |
| templateType           | 模板类型             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                      | **说明**             |
|-------------------------------|----------------------|
| errcode                       | 返回码               |
| errmsg                        | 状态码对应的信息文本 |
| data                          | 返回数据             |
| $.data.id                     | 报表id               |

### **更新报表**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/reports

**参数说明：**

**请求包体：**

```
{
	"applicationid": "sOZu9kthmxyP8qQfq0e",
	"parentId": "__jdnS7aKT9LklWZGoZgD",
	"name": "单元测试666",
	"dataSourceName": "4.0功能示例",
	"dataSourceType": "DATASOURCE_TYPE_SQL",
	"viewId": "",
	"formId": "",
	"dataSourceSqlScript": "12345",
	"procedureScript": "",
	"dataSourceCustomScript": "",
	"templateType": "JRXML",
	"jrxmlString": "jrxmlstring12345",
	"isDefaultStyle": "0",
	"jrxmlFilePath": "路径",
	"subReportId": "子报表id",
	"dataSourceSearchForm": "",
	"description": "备注",
	"isPrint": 0,
	"id": id
}
```

**包体参数说明：**

| **参数**               | **说明**             |
|------------------------|----------------------|
| name                   | 报表名称             |
| description            | 描述                 |
| scriptTemplate         | 模板脚本             |
| xmlTemplate            | 模板xml              |
| dataSourceType         | 数据源类型           |
| dataSourceSearchForm   | 数据源查询表单       |
| dataSourceSqlScript    | 数据源sql脚本        |
| dataSourceCustomScript | 自定义数据源脚本     |
| jrxmlFilePath          | jrxml文件路径地址    |
| dataSourceName         | 数据源名称           |
| isDefaultStyle         | 默认样例             |
| viewId                 | 关联视图id           |
| reportExampleName      | 样例名称             |
| procedureScript        | 存储过程数据源脚本   |
| templateType           | 模板类型             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "description": "description",
        "scriptTemplate": "scriptTemplate",
        "xmlTemplate": "xmlTemplate",
        "dataSourceType": "dataSourceType",
        "dataSourceSearchForm": "dataSourceSearchForm",
        "dataSourceSqlScript": "dataSourceSqlScript",
        "dataSourceCustomScript": "dataSourceCustomScript",
        "jrxmlFilePath": "jrxmlFilePath",
        "dataSourceName": "dataSourceName",
        "isDefaultStyle": 0,
        "viewId": "viewId",
        "reportExampleName": "reportExampleName",
        "procedureScript": "procedureScript",
        "templateType": "templateType"
    }
}

```

**参数说明：**

| **参数**                      | **说明**             |
|-------------------------------|----------------------|
| errcode                       | 返回码               |
| errmsg                        | 状态码对应的信息文本 |
| data                          | 返回数据             |
| $.data.id                     | 报表id               |
| $.data.name                   | 报表名称             |
| $.data.description            | 描述                 |
| $.data.scriptTemplate         | 模板脚本             |
| $.data.xmlTemplate            | 模板xml              |
| $.data.dataSourceType         | 数据源类型           |
| $.data.dataSourceSearchForm   | 数据源查询表单       |
| $.data.dataSourceSqlScript    | 数据源sql脚本        |
| $.data.dataSourceCustomScript | 自定义数据源脚本     |
| $.data.jrxmlFilePath          | jrxml文件路径地址    |
| $.data.dataSourceName         | 数据源名称           |
| $.data.isDefaultStyle         | 默认样例             |
| $.data.viewId                 | 关联视图id           |
| $.data.reportExampleName      | 样例名称             |
| $.data.procedureScript        | 存储过程数据源脚本   |
| $.data.templateType           | 模板类型             |

### **删除报表（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/reports

**参数说明：**

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 报表id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **通过数据源获取返回结果集的列信息**

------

**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/reports/getQueryColumnInfos?type={type}

**参数说明：**

**请求包体：**

```
{
    “scriptString”："scriptString"
}
```

**包体参数说明：**

| **参数**       | 必须 | **说明**                                  |
| -------------- | ---- | ----------------------------------------- |
| applicationId  | 是   | 软件id                                    |
| reportId       | 否   | 报表id                                    |
| dataSourceName | 否   | 数据源名称(sql数据源和存储过程数据源要传) |
| type           | 是   | 数据源类型                                |
| viewId         | 否   | 视图id                                    |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"columnName": "所属公司",
		"columnTypeName": "VALUE_TYPE_VARCHAR",
		"columnClassName": "java.lang.String",
		"columnLabel": "所属公司"
	}, {
		"columnName": "代收公司",
		"columnTypeName": "VALUE_TYPE_VARCHAR",
		"columnClassName": "java.lang.String",
		"columnLabel": "代收公司"
	}]
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### 获取jrxml字符串

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/reports/getJrxmlString?id={id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 报表id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "jrxmlString"
}

```
**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | jrxml字符串          |

### 获取ReportExamples的iscript脚本

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/reports/getExampleIscriptString?exampleName={exampleName}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| exampleName       | 是       | 示例名称   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "iscriptString"
}

```
**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | iscript脚本          |

### 接收上传图片接口

------

**请求方式：** POST
**请求地址：** /api/designtime/applications/reports/uploadImageFile

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| file     | 是       | 文件的二进制流 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "realPath"
}

```
**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 图片路径             |

### 返回报表的jasper文件路径

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/reports/getReportJasperPath?reportId={reportId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| reportId | 是       | 报表id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "realPath"
}

```
**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | japser文件路径       |
### 报表预览返回html路径

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/reports/showjrxml/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 报表id   |
| domainId       | 否       | 企业域id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "htmlPath"
}

```
**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | html路径             |

### 返回企业域列表

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/reports/getDomainList

**参数说明：**

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"name": "测试",
		"id": "3CffNlgt9B9StIjIUPB",
		"status": 1,
		"logoUrl": "",
		"systemName": "",
		"users": [{
			"userid": "2TE7lzsbdyqLhndabbN",
			"username": "sam_hr"
		}, {
			"userid": "zPsp2hk7CEwtqeMCwtj",
			"username": "大间谍"
		}, {
			"userid": "iM16sApAfO0CdXXFnOH",
			"username": "RU"
		}]
	}]
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 数据包             |



## 10. **角色（Roles）**

### **获取角色列表（可根据名字查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/roles?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**     |
| ------------- | -------- | ------------ |
| applicationId | 是       | 软件id       |
| name          | 否       | 查询名称     |
| pageNo        | 否       | 第几页       |
| linesPerPage  | 否       | 每页显示条数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 22,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "fBUXdkAlWTdGXqOq4cI",
                "name": "员工",
                "roleNo": "002",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            },
            ....
        ],
        "pageCount": 3
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 角色id               |
| $.data.name        | 角色名称             |


### **获取角色详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/roles/{roleId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| roleId   | 是       | 角色id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "roleNo": "roleNo",
        "status": "status",
        "defaultRole": "defaultRole"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 角色id               |
| $.data.name        | 角色名称             |
| $.data.roleNo      | 编号                 |
| $.data.status      | 激活状态             |
| $.data.defaultRole | 系统默认角色         |

### **新建角色**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/roles

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "roleNo": "roleNo",
    "status": 1,
    "defaultRole": true
}
```

**包体参数说明：**

| **参数**    | **说明**                    |
| ----------- | --------------------------- |
| name        | 角色名称                    |
| roleNo      | 编号                        |
| status      | 激活状态（0\|1）            |
| defaultRole | 系统默认角色（true\|false） |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 角色id               |

### **更新角色**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/roles/{roleId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| roleId   | 是       | 角色id   |

**请求包体：**

```
{
    "name": "name",
    "roleNo": "roleNo",
    "status": 1,
    "defaultRole": true
}
```

**包体参数说明：**

| **参数**    | **说明**                    |
| ----------- | --------------------------- |
| name        | 角色名称                    |
| roleNo      | 编号                        |
| status      | 激活状态（0\|1）            |
| defaultRole | 系统默认角色（true\|false） |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除角色（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/roles

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 角色id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 11. **菜单（Menus）**
### **获取菜单列表（根据上级）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/menus?isMobile={isMobile}&parentId={parentId}

**参数说明：**

| **参数**      | **必须** | **说明**                |
| ------------- | -------- | ----------------------- |
| applicationId | 是       | 软件id                  |
| parentId      | 否       | 父级id                  |
| isMobile      | 是       | 是否移动端(true或false) |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"superior": "",
		"hasChild": false,
		"name": "报表示例",
		"id": "__iOzzZe327RbzWp9pVGK",
		"applicationId": "sOZu9kthmxyP8qQfq0e",
		"uri": "/4.0功能示例.application/报表示例.menu/报表示例.menu"
	}]
}

```

**参数说明：**

| **参数**         | **说明**             |
|------------------|----------------------|
| errcode          | 返回码               |
| errmsg           | 状态码对应的信息文本 |
| data             | 返回数据             |
| $.data.id        | 菜单id               |
| $.data.name      | 菜单名称             |
| $.data.superior  | 上级菜单id           |
| $.data.orderNo   | 排序号               |

### **获取菜单详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/menus/{menuId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| menuId        |    是    | 菜单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "XjlBS3EkUoFjn0uKyqz",
		"name": "辅助测试",
		"description": "辅助测试",
		"type": "00",
		"opentarget": "detail",
		"ico": "{\"icon\":\"/uploads/lib/icon//p01_home.png\",\"icontype\":\"img\"}",
		"allowOpenFrom": true,
		"allowOpenView": true,
		"linkName": "辅助测试",
		"moduleid": "QupVVCsnfsHo0munijD",
		"directory": "portal",
		"actionContent": "CCmRfhRrW6fdHivAxlk",
		"actionExcelImport": "__6XGibM8vHvaKjA1XJeS",
		"queryString": "[]",
		"permissionType": "public",
		"showType": 0,
		"isUsual": "false",
		"isMobile": "false",
		"orderno": 10,
		"showtotalrow": "false",
		"htmlTerminal": true,
		"mobileTerminal": true
	}
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 菜单id               |
| $.data.name               | 菜单名称             |
| $.data.description        | 描述                 |
| $.data.multiLanguageLabel | 多语言标签           |
| $.data.type               | 类型                 |
| $.data.opentarget         | 打开链接方式         |
| $.data.ico                | 图标                 |
| $.data.superior           | 上级菜单id           |
| $.data.linkName           | 菜单名称             |
| $.data.linkType           | 链接类型             |
| $.data.moduleid           | 模块id               |
| $.data.directory          | 目录                 |
| $.data.actionContent      | 动作内容             |
| $.data.queryString        | 参数                 |
| $.data.permissionType     | 权限                 |
| $.data.showType           | 显示方式             |
| $.data.isUsual            | 是否常用             |
| $.data.isMobile           | 是否为手机菜单       |
| $.data.orderNo            | 排序号               |
| $.data.showtotalrow       | 是否显示记录总数     |

### **复制菜单**
----------
**请求方式：** POST 
**请求地址：** /api/designtime/applications/{applicationId}/menus/copy?destid={destid}&isMobile={isMobile}

**参数说明：**

| **参数**      | **必须** | **说明**     |
| ------------- | -------- | ------------ |
| applicationId | 是       | 软件id       |
| destid        | 是       | 目标上级菜单 |
| isMobile      | 是       | 是否移动端   |
**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
| -------- | -------- |
| id       | 菜单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **新建菜单**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/menus

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| applicationId | 是       | 软件id     |
| isMobile      | 是       | 是否移动端 |
| content       | 是       | 请求包体   |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "multiLanguageLabel": "multiLanguageLabel",
    "type": "type",
    "opentarget": "opentarget",
    "ico": "ico",
    "superior": "superior",
    "linkName": "linkName",
    "linkType": "linkType",
    "moduleid": "moduleid",
    "directory": "directory",
    "actionContent": "actionContent",
    "queryString": "queryString",
    "permissionType": "permissionType",
    "showType": "showType",
    "isUsual": "isUsual",
    "isMobile": "isMobile",
    "orderno": 0,
    "showtotalrow": "showtotalrow"
}
```

**包体参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| name               | 菜单名称             |
| description        | 描述                 |
| multiLanguageLabel | 多语言标签           |
| type               | 类型                 |
| opentarget         | 打开链接方式         |
| ico                | 图标                 |
| superior           | 上级菜单id           |
| linkName           | 菜单名称             |
| linkType           | 链接类型             |
| moduleid           | 模块id               |
| directory          | 目录                 |
| actionContent      | 动作内容             |
| queryString        | 参数                 |
| permissionType     | 权限                 |
| showType           | 显示方式             |
| isUsual            | 是否常用             |
| isMobile           | 是否为手机菜单       |
| orderNo            | 排序号               |
| showtotalrow       | 是否显示记录总数     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 菜单id               |

### **更新菜单**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/{applicationId}/menus/{menuId}

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| applicationId | 是       | 软件id     |
| menuId        | 是       | 菜单id     |
| superiorId    | 否       | 上级菜单id |
| content       | 是       | 请求包体   |

**请求包体：**

```
{
    "name": "name",
    "description": "description",
    "multiLanguageLabel": "multiLanguageLabel",
    "type": "type",
    "opentarget": "opentarget",
    "ico": "ico",
    "superior": "superior",
    "linkName": "linkName",
    "linkType": "linkType",
    "moduleid": "moduleid",
    "directory": "directory",
    "actionContent": "actionContent",
    "queryString": "queryString",
    "permissionType": "permissionType",
    "showType": "showType",
    "isUsual": "isUsual",
    "isMobile": "isMobile",
    "orderNo": "orderNo",
    "showtotalrow": "showtotalrow"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除菜单（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/menus

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 菜单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **根据表单创建菜单**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/form/{formId}/menus

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| formId        |    是    | 表单id   |

**请求包体：**

```
{
    "name": "name",
    "superior": "superior"
}
```

**包体参数说明：**

| **参数**   | **说明**   |
|------------|------------|
| name       | 菜单名称   |
| superior   | 上级菜单id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **根据视图创建菜单**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/view/{viewId}/menus

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |

**请求包体：**

```
{
    "name": "name",
    "superior": "superior"
}
```

**包体参数说明：**

| **参数**   | **说明**   |
|------------|------------|
| name       | 菜单名称   |
| superior   | 上级菜单id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取所有菜单**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/menu/getAllMenus?currentMenuId={currentMenuId}&type={type}&showType={showType}&name={name}

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| applicationId | 是       | 软件id     |
| currentMenuId | 否       | 当前菜单id |
| type          | 否       | 菜单类型   |
| showType      | 是       | 类型       |
| name          | 否       | 菜单名称   |

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"id": "",
		"value": "无"
	}, {
		"id": "__CAQYDSxmmOxMhrnq9b5",
		"value": "接口测试"
	}, {
		"id": "__nIR7tcVaHuUwph5r4cc",
		"value": "|---请假测试"
	}]
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### 获取图标集合

**请求方式：** GET  
**请求地址：** /api/designtime/applications/icons

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| 无       | 否       |          |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"name": "icon-workflow.png",
		"size": "32 x 32",
		"length": "1.26 KB",
		"width": 32,
		"path": "/uploads/lib/icon/icon-workflow.png",
		"fileType": 1
	}, {
		"name": "p01_home.png",
		"size": "200 x 200",
		"length": "4.71 KB",
		"width": 200,
		"path": "/uploads/lib/icon/p01_home.png",
		"fileType": 1
	}]
}

```

**参数说明：**

| **参数**         | **说明**                 |
| ---------------- | ------------------------ |
| errcode          | 返回码（0=成功，1=失败） |
| errmsg           | 对返回码的文本描述内容   |
| data             | 企业域集合               |
| data[0].name     | logo名称                 |
| data[0].size     | logo尺寸                 |
| data[0].length   | 文件大小                 |
| data[0].width    | logo长                   |
| data[0].path     | logo路径                 |
| data[0].fileType | 文件类型                 |

### 删除自定义图标

**请求方式：** DELETE  
**请求地址：** /api/designtime/applications/icon

**参数说明：**

| **参数** | **必须** | **说明**             |
| -------- | -------- | -------------------- |
| path     | 是       | 自定义icon的相对路径 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

## 12. **小工具 （Widgets）**

### **获取小工具列表（可根据名字查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/widgets?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 否       | 查询名称 |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 3,
		"data": [{
			"id": "__7yF3Ta1M06pk8NkDJ8M",
			"name": "统计图",
			"type": "chart",
			"published": true,
			"orderNo": 2
		}, {
			"id": "__I4G5rQJjGOPznbmK93n",
			"name": "统计图跳转视图",
			"type": "chart",
			"published": true,
			"orderNo": 3
		}, {
			"id": "__HqIe9aH2G8QOlDGXjht",
			"name": "流程处理",
			"type": "system_workflow",
			"published": true,
			"orderNo": 1
		}]
	}
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 小工具id             |
| $.data.name               | 小工具名称           |
| $.data.type               | 类型                 |
| $.data.published          | 是否发布             |
| $.data.orderNo            | 排序号               |

### **获取小工具详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/widgets/{widgetId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| widgetId | 是       | 小工具id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"summaryName": "",
		"data": {
			"id": "__C6X9jDt7nWnMHi5cR0a",
			"name": "单元测试666__C6X9jDt7nWnMHi5cR0a",
			"description": null,
			"type": "view",
			"moduleid": "__jdnS7aKT9LklWZGoZgD",
			"actionContent": "__LzvbwJGuzjepcTM3ygs",
			"queryString": null,
			"width": null,
			"height": null,
			"authMode": 0,
			"authRolesId": null,
			"authRolesName": null,
			"published": true,
			"icon": "{\"icon\":\"if-lib icon-xinwenxinxi\",\"icontype\":\"font\",\"iconFontColor\":\"#000\"}",
			"icontype": null,
			"titleColor": "#000",
			"titleBColor": null,
			"iconShow": false,
			"widgetType": 0,
			"orderno": null
		}
	}
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 小工具id             |
| $.data.name               | 小工具名称           |
| $.data.type               | 类型                 |
| $.data.moduleid           | 模块id               |
| $.data.actionContent      | 动作内容             |
| $.data.width              | 宽度                 |
| $.data.height             | 高度                 |
| $.data.authMode           | 授权方式             |
| $.data.authRolesId        | 授权角色id           |
| $.data.authRolesName      | 授权角色名称         |
| $.data.published          | 是否发布             |
| $.data.icon               | 图标                 |
| $.data.titleColor         | 标题颜色             |
| $.data.titleBColor        | 标题背景颜色         |
| $.data.iconShow           | 图标形式显示         |
| $.data.widgetType         | 支持类型             |
| $.data.orderNo            | 排序号               |

### **新建小工具**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/widgets

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
	"name": "单元测试666",
	"type": "view",
	"moduleid": "__jdnS7aKT9LklWZGoZgD",
	"actionContent": "__LzvbwJGuzjepcTM3ygs",
	"width": "",
	"height": "",
	"authMode": 0,
	"authRolesId": "",
	"authRolesName": "",
	"published": true,
	"icon": "{\"icon\":\"if-lib icon-xinwenxinxi\",\"icontype\":\"font\",\"iconFontColor\":\"#000\"}",
	"titleColor": "#000",
	"titleBColor": "",
	"iconShow": "",
	"widgetType": 0,
	"orderNo": "1"
}
```

**包体参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| name               | 小工具名称           |
| type               | 类型                 |
| moduleid           | 模块id               |
| actionContent      | 动作内容             |
| width              | 宽度                 |
| height             | 高度                 |
| authMode           | 授权方式             |
| authRolesId        | 授权角色id           |
| authRolesName      | 授权角色名称         |
| published          | 是否发布             |
| icon               | 图标                 |
| titleColor         | 标题颜色             |
| titleBColor        | 标题背景颜色         |
| iconShow           | 图标形式显示         |
| widgetType         | 支持类型             |
| orderNo            | 排序号               |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 小工具id             |

### **更新小工具**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/widgets

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| widgetId |    是    | 小工具id   |

**请求包体：**

```
{
	"id": "id",
	"name": "单元测试666",
	"applicationid": "sOZu9kthmxyP8qQfq0e",
	"parentId": "sOZu9kthmxyP8qQfq0e",
	"type": "view",
	"moduleid": "__jdnS7aKT9LklWZGoZgD",
	"actionContent": "__LzvbwJGuzjepcTM3ygs",
	"width": "",
	"height": "",
	"authMode": 0,
	"authRolesId": "",
	"authRolesName": "",
	"published": true,
	"icon": "{\"icon\":\"if-lib icon-xinwenxinxi\",\"icontype\":\"font\",\"iconFontColor\":\"#000\"}",
	"titleColor": "#000",
	"titleBColor": "",
	"iconShow": "",
	"widgetType": 0,
	"orderNo": "1"
}
```

**包体参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| name               | 小工具名称           |
| type               | 类型                 |
| moduleid           | 模块id               |
| actionContent      | 动作内容             |
| width              | 宽度                 |
| height             | 高度                 |
| authMode           | 授权方式             |
| authRolesId        | 授权角色id           |
| authRolesName      | 授权角色名称         |
| published          | 是否发布             |
| icon               | 图标                 |
| titleColor         | 标题颜色             |
| titleBColor        | 标题背景颜色         |
| iconShow           | 图标形式显示         |
| widgetType         | 支持类型             |
| orderNo            | 排序号               |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除小工具（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/widgets

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 小工具id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 13.  **任务（Tasks）**
### **获取任务列表（可根据名字或者描述查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/tasks?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**         |
|---------------|----------|------------------|
| applicationId |    是    | 软件id           |
| searchword    |    否    | 查询名称或者描述 |
| pageNo      | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "__TclUNSaEQzATXeAS2op",
			"name": "单元测试__TclUNSaEQzATXeAS2op",
			"type": 1,
			"description": "description",
			"runningTime": "2020-04-27T09:27:07.000+0000",
			"period": 0,
			"runtimes": 0,
			"terminateScript": "terminateScript",
			"taskScript": "taskScript",
			"modifyTime": "2020-05-07T08:23:25.093+0000",
			"creator": "Admin",
			"creatorid": "Ai6hllhNjS2ull9TKGb",
			"totalRuntimes": 0,
			"state": 0,
			"startupType": 0,
			"daysOfWeek": [],
			"dayOfMonth": 1,
			"repeatTimes": 0,
			"frequency": 0,
			"executedCount": 0,
			"modifyTiemStr": "2020-05-07"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 任务id               |
| $.data.name               | 任务名称             |
| $.data.period             | 周期                 |
| $.data.modifyTime         | 最后更新时间         |
| $.data.creator            | 创建人               |
| $.data.state              | 启动状态             |
| $.data.startupType        | 启动类型             |
| $.data.executedCount      | 执行计数             |

### **获取任务详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/tasks/{taskId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| taskId   | 是       | 任务id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__TCAw86jn60Vwtna5TaI",
		"name": "单元测试__TCAw86jn60Vwtna5TaI",
		"type": 1,
		"description": "description",
		"runningTime": "2020-04-27T09:27:07.000+0000",
		"period": 0,
		"runtimes": 0,
		"terminateScript": "terminateScript",
		"taskScript": "taskScript",
		"modifyTime": "2020-04-28T06:36:44.000+0000",
		"creator": "Admin",
		"creatorid": "",
		"totalRuntimes": 0,
		"state": 0,
		"startupType": 0,
		"daysOfWeek": [],
		"dayOfMonth": 1,
		"repeatTimes": 0,
		"frequency": 0,
		"executedCount": 0,
		"modifyTiemStr": "2020-04-28"
	}
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 任务id               |
| $.data.name               | 任务名称             |
| $.data.type               | 类型                 |
| $.data.description        | 描述                 |
| $.data.runningTime        | 运行时间             |
| $.data.period             | 周期                 |
| $.data.runtimes           | 运行次数             |
| $.data.terminateScript    | 终止脚本             |
| $.data.taskScript         | 任务脚本             |
| $.data.modifyTime         | 最后更新时间         |
| $.data.creator            | 创建人               |
| $.data.creatorid          | 创建人id             |
| $.data.totalRuntimes      | 总运行次数           |
| $.data.state              | 启动状态             |
| $.data.startupType        | 启动类型             |
| $.data.daysOfWeek         | 星期数               |
| $.data.dayOfMonth         | 每月运行日期         |
| $.data.repeatTimes        | 运行次数             |
| $.data.frequency          | 重复率               |
| $.data.executedCount      | 执行计数             |

### **新建任务**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/tasks?rDate={rDate}&rTime={rTime}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| rDate         | 是       | 运行日期 |
| rTime         | 是       | 运行时间 |

**请求包体：**

```
{
	"name": "单元测试",
	"creatorid": "Ai6hllhNjS2ull9TKGb",
	"creator": "Admin",
	"type": 1,
	"startupType": 0,
	"period":0,
	"description": "description",
	"terminateScript": "terminateScript",
	"taskScript": "taskScript",
	"id": "id"
}
```

**包体参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| name               | 任务名称             |
| type               | 类型                 |
| description        | 描述                 |
| runningTime        | 运行时间             |
| period             | 周期                 |
| runtimes           | 运行次数             |
| terminateScript    | 终止脚本             |
| taskScript         | 任务脚本             |
| modifyTime         | 最后更新时间         |
| creator            | 创建人               |
| creatorid          | 创建人id             |
| totalRuntimes      | 总运行次数           |
| state              | 启动状态             |
| startupType        | 启动类型             |
| daysOfWeek         | 星期数               |
| dayOfMonth         | 每月运行日期         |
| repeatTimes        | 运行次数             |
| frequency          | 重复率               |
| executedCount      | 执行计数             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**                  | **说明**             |
|---------------------------|----------------------|
| errcode                   | 返回码               |
| errmsg                    | 状态码对应的信息文本 |
| data                      | 返回数据             |
| $.data.id                 | 任务id               |

### **更新任务**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/tasks

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| taskId |    是    | 任务id   |

**请求包体：**

```
{
	"name": "单元测试666",
	"applicationid": "sOZu9kthmxyP8qQfq0e",
	"parentId": "sOZu9kthmxyP8qQfq0e",
	"creatorid": "Ai6hllhNjS2ull9TKGb",
	"creator": "Admin",
	"type": 1,
	"startupType": 0,
	"period": 0,
	"description": "description",
	"terminateScript": "terminateScript",
	"taskScript": "taskScript",
	"id": "id "
}
```

**包体参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| name               | 任务名称             |
| type               | 类型                 |
| description        | 描述                 |
| runningTime        | 运行时间             |
| period             | 周期                 |
| runtimes           | 运行次数             |
| terminateScript    | 终止脚本             |
| taskScript         | 任务脚本             |
| modifyTime         | 最后更新时间         |
| creator            | 创建人               |
| creatorid          | 创建人id             |
| totalRuntimes      | 总运行次数           |
| state              | 启动状态             |
| startupType        | 启动类型             |
| daysOfWeek         | 星期数               |
| dayOfMonth         | 每月运行日期         |
| repeatTimes        | 运行次数             |
| frequency          | 重复率               |
| executedCount      | 执行计数             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除任务（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/{applicationId}/tasks

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 任务id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **开始任务**

------

**请求方式：** PUT
**请求地址：** /api/designtime/applications/task/start?rDate={rDate}&rTime={rTime}&id={id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 任务id   |
| rDate    | 是       | 运行日期 |
| rTime    | 是       | 运行时间 |

**请求包体：**

```
无
```

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"runState": 1,
		"msg": "定时任务已经启动"
	}
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

### **停止任务**

------

**请求方式：** PUT
**请求地址：** /api/designtime/applications/task/stop?id={id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 任务id   |

**请求包体：**

```
无
```

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"runState": 1,
		"msg": "定时任务已经停止"
	}
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

## 14.  **状态标签（StateLabels）**

### **获取状态标签列表（可根据名字或者描述查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId}/statelabels?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**         |
| ------------- | -------- | ---------------- |
| applicationId | 是       | 软件id           |
| searchword    | 否       | 查询名称或者描述 |
| pageNo        | 否       | 页码             |
| linesPerPage  | 否       | 页条数           |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 1,
		"data": [{
			"id": "3vx33GoJUElQdo0VuWA",
			"name": "人事",
			"description": "",
			"value": "人事",
			"orderNo": "1"
		}]
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 状态标签id           |
| $.data.name        | 状态标签名称         |
| $.data.description | 描述                 |
| $.data.value       | 值                   |
| $.data.orderNo     | 排序号               |

### **获取状态标签详情**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/statelabels/{stateLabelId}

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId |    是    | 软件id     |
| stateLabelId  |    是    | 状态标签id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "3vx33GoJUElQdo0VuWA",
		"name": "人事",
		"description": "",
		"value": "人事",
		"orderNo": "1"
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 状态标签id           |
| $.data.name        | 状态标签名称         |
| $.data.description | 描述                 |
| $.data.value       | 值                   |
| $.data.orderNo     | 排序号               |

### **新建状态标签**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/statelabels

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "parentId":"parentId",
    "applicationid":"applicationid",
    "description": "description",
    "value": "value",
    "orderNo": "orderNo"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 状态标签名称         |
| description | 描述                 |
| value       | 值                   |
| orderNo     | 排序号               |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 状态标签id           |

### **更新状态标签**
----------
**请求方式：** PUT
**请求地址：** /api/designtime/applications/statelabels

**请求包体：**

```
{
    "name": "name",
    "id":"id",
    "parentId":"parentId",
    "applicationid":"applicationid",
    "description": "description",
    "value": "value",
    "orderNo": "orderNo"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 状态标签名称         |
| description | 描述                 |
| value       | 值                   |
| orderNo     | 排序号               |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除状态标签（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/statelabels

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明**     |
|----------|--------------|
| id       | 状态标签id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 15.  **开发者（Developers）**
### **获取已加入软件的开发者列表（可根据名字查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId/superusers/join?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 否       | 查询名字 |
| pageNo        | 否       | 当前页数 |
| linesPerPage  | 否       | 每页行数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "Ai6hllhNjS2ull9TKGb",
			"name": "Admin",
			"domains": null,
			"applications": [{
				"id": "sOZu9kthmxyP8qQfq0e",
				"name": "4.0功能示例",
				"type": 0,
				"description": "适用于4.0+版本的功能测试",
				"activated": true
			}],
			"loginno": "admin",
			"loginpwd": "3e2708abc7e6158d446248d0d89cf6519ca9fec29b4e2384248e8554d394f1b4",
			"email": null,
			"status": 1,
			"pwdErrorTimes": 0,
			"superAdmin": true,
			"developer": true,
			"secret": "11ea-26da-744a17bc-bd03-5fe935119e1e"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 开发者id             |
| $.data.name        | 开发者名称           |
| $.data.loginno     | 账号                 |
| $.data.email       | 邮箱                 |

### **获取未加入软件的开发者列表（可根据名字查询）**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/{applicationId/superusers/unjoin?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 否       | 查询名字 |
| pageNo        | 否       | 当前页数 |
| linesPerPage  | 否       | 每页行数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "Ai6hllhNjS2ull9TKGb",
			"name": "Admin",
			"domains": null,
			"applications": [{
				"id": "sOZu9kthmxyP8qQfq0e",
				"name": "4.0功能示例",
				"type": 0,
				"description": "适用于4.0+版本的功能测试",
				"activated": true
			}],
			"loginno": "admin",
			"loginpwd": "3e2708abc7e6158d446248d0d89cf6519ca9fec29b4e2384248e8554d394f1b4",
			"email": null,
			"status": 1,
			"pwdErrorTimes": 0,
			"superAdmin": true,
			"developer": true,
			"secret": "11ea-26da-744a17bc-bd03-5fe935119e1e"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**       | **说明**             |
| -------------- | -------------------- |
| errcode        | 返回码               |
| errmsg         | 状态码对应的信息文本 |
| data           | 返回数据             |
| $.data.id      | 开发者id             |
| $.data.name    | 开发者名称           |
| $.data.loginno | 账号                 |
| $.data.email   | 邮箱                 |

### **添加开发者（可批量）**

----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/superusers

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| id          | 开发者id             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **移除开发者（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/{applicationId}/superusers

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| id          | 开发者id             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **获取特权用户信息**

------

**请求方式：** GET
**请求地址：** /api/designtime/applications/getSuperuser

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "Ai6hllhNjS2ull9TKGb",
		"name": "Admin1",
		"loginno": "admin",
		"loginpwd": "ffcbfbb450f0345bb6fce62e19e9f739e3e63070a2ada131595f66c12a0ca969",
		"email": "1799568881@qq.com"
	}
}

```

**参数说明：**

| **参数**        | **说明**             |
| --------------- | -------------------- |
| errcode         | 返回码               |
| errmsg          | 状态码对应的信息文本 |
| data            | 返回数据             |
| $.data.name     | 用户姓名             |
| $.data.loginno  | 用户账号             |
| $.data.loginpwd | 用户密码             |
| $.data.email    | 邮箱                 |

### **修改特权用户信息**

------

**请求方式：** PUT
**请求地址：** /api/designtime/applications/superuser/{userId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| userId   | 是       | 用户id   |

**请求包体：**

```
{
    "name": "name",
    "email":"email",
    "loginno":"loginno",
    "loginpwd":"loginpwd"
}
```

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok"
}

```

**参数说明：**

| **参数**        | **说明**             |
| --------------- | -------------------- |
| errcode         | 返回码               |
| errmsg          | 状态码对应的信息文本 |
| data            | 返回数据             |
| $.data.name     | 用户姓名             |
| $.data.loginno  | 用户账号             |
| $.data.loginpwd | 用户密码             |
| $.data.email    | 邮箱                 |

## 16.  **excel配置（ExcelConfigs）**

### **获取excel配置列表（可根据名字查询）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/excelconfigs?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 是       | 查询名称 |
| pageNo        | 否       | 当前页数 |
| linesPerPage  | 否       | 每页行数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 2,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "__6XGibM8vHvaKjA1XJeS",
			"uri": "/4.0功能示例.application/as.excelconfig/as.excelconfig",
			"name": "as",
			"templatePath": "/uploads/exceltemplate/到达.xls"
		}, {
			"id": "__lr4xpsC2GullVuyW3p4",
			"uri": "/4.0功能示例.application/操作按钮表单.excelconfig",
			"name": "操作按钮表单",
			"templatePath": "/uploads/exceltemplate/操作按钮表单.xls"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | excel配置id          |
| $.data.name        | excel配置名称        |

### **获取excel配置详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/excelconfigs/{excelConfigId}

**参数说明：**

| **参数**      | **必须** | **说明**      |
|---------------|----------|---------------|
| applicationId |    是    | 软件id        |
| excelConfigId |    是    | excel配置id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id",
        "name": "name",
        "xml": "xml",
        "templatePath":"templatePath"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | excel配置id          |
| $.data.name        | excel配置名称        |
| $.data.xml         | 源代码               |
| $.data.templatePath| 模板文件路径地址     |

### **新建excel配置**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/excelconfigs

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "xml": "xml",
    "templatePath":"templatePath"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | excel配置名称        |
| xml         | 源代码               |
| templatePath| 模板文件路径地址     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | excel配置id          |

### **更新excel配置**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/excelconfigs

**参数说明：**

| **参数**      | **必须** | **说明**      |
|---------------|----------|---------------|
| applicationId |    是    | 软件id        |
| excelConfigId |    是    | excel配置id   |

**请求包体：**

```
{
	"id":"id",
    "name": "name",
    "xml": "xml",
    "templatePath":"templatePath"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | excel配置名称        |
| xml         | 源代码               |
| templatePath| 模板文件路径地址     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除excel配置（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/excelconfigs

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明**      |
|----------|---------------|
| id       | excel配置id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | 返回数据 |

## 17.  **数据源（DataSources）**
### **获取数据源列表（可根据名字查询）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 是       | 查询名称 |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 2,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "rDXojBcjqZudUraN1Yc",
			"name": "4.0功能示例",
			"useType": "JDBC",
			"driverClass": "com.mysql.jdbc.Driver",
			"url": "jdbc:mysql://localhost:3306/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
			"username": "root",
			"password": "root",
			"dbType": 4,
			"poolsize": "300",
			"timeout": "3600",
			"jndiName": "",
			"providerUrl": "",
			"initialContextFactory": null,
			"urlPkgPrefixes": "",
			"securityPrincipal": "",
			"securityCredentials": "",
			"dbTypeName": "MYSQL",
			"readonly" : 是否开启读写分离,
            "readonlyUseType": 使用类型,
            "readonlyDbType": 数据库类型,
            "readonlyUsername": 用户名称,
            "readonlyDriverClass": 数据驱动,
            "readonlyPassword": 密码,
            "readonlyUrl": 地址,
            "readonlyPoolsize": 连接池大小,
            "readonlyTimeout": 连接超时时间,
            "readonlyJndiName": JNDI名称,
            "readonlyInitialContextFactory": "INITIAL_CONTEXT_FACTORY",
            "readonlyUrlPkgPrefixes": "URL_PKG_PREFIXES",
            "readonlyProviderUrl": "PROVIDER_URL",
            "readonlySecurityPrincipal": "SECURITY_PRINCIPAL",
            "readonlySecurityCredentials": "SECURITY_CREDENTIALS"
		}, {
			"id": "__AhqIuqXvRUzJGrv5okH",
			"name": "接口测试",
			"useType": "JDBC",
			"driverClass": "com.mysql.jdbc.Driver",
			"url": "jdbc:mysql://localhost:3307/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
			"username": "root",
			"password": "",
			"dbType": 4,
			"poolsize": "300",
			"timeout": "3000",
			"jndiName": "",
			"providerUrl": "",
			"initialContextFactory": null,
			"urlPkgPrefixes": "",
			"securityPrincipal": "",
			"securityCredentials": "",
			"dbTypeName": "MYSQL",
			"readonly" : 是否开启读写分离,
            "readonlyUseType": 使用类型,
            "readonlyDbType": 数据库类型,
            "readonlyUsername": 用户名称,
            "readonlyDriverClass": 数据驱动,
            "readonlyPassword": 密码,
            "readonlyUrl": 地址,
            "readonlyPoolsize": 连接池大小,
            "readonlyTimeout": 连接超时时间,
            "readonlyJndiName": JNDI名称,
            "readonlyInitialContextFactory": "INITIAL_CONTEXT_FACTORY",
            "readonlyUrlPkgPrefixes": "URL_PKG_PREFIXES",
            "readonlyProviderUrl": "PROVIDER_URL",
            "readonlySecurityPrincipal": "SECURITY_PRINCIPAL",
            "readonlySecurityCredentials": "SECURITY_CREDENTIALS"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**            | **说明**              |
|---------------------|-----------------------|
| errcode             | 返回码                |
| errmsg              | 状态码对应的信息文本  |
| data                | 返回数据              |
| $.data.id           | 数据源id              |
| $.data.name         | 数据源名称            |
| $.data.username     | 用户名称              |
| $.data.password     | 密码                  |
| $.data.driverClass  | 数据驱动              |
| $.data.url          | 地址                  |

### **获取元数据列表**

------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/getMetadata?datasourceId={datasourceId}&subNodes={subNodes}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| datasourceId  | 是       | 数据源id |
| subNodes      | 否       | 子节点   |
|               |          |          |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":[{"id":"rDXojBcjqZudUraN1Yc","data":"4.0功能示例","state":"closed","attr":{"id":"rDXojBcjqZudUraN1Yc","name":"4.0功能示例","appication":null,"datasourceId":"rDXojBcjqZudUraN1Yc","curNode":"isDts","rel":"db_selected","subNodes":"isTables"}},{"id":"__AhqIuqXvRUzJGrv5okH","data":"接口测试","state":"closed","attr":{"id":"__AhqIuqXvRUzJGrv5okH","name":"接口测试","appication":null,"datasourceId":"__AhqIuqXvRUzJGrv5okH","curNode":"isDts","rel":"db","subNodes":"isTables"}}]}
```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

### **获取元数据索引列表**

------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/getIndex?datasourceId={datasourceId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| datasourceId  | 是       | 数据源id |
|               |          |          |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":[{"name":"auth_finddocument﻿","columns":[{"name":"ID","dataType":12,"primaryKey":true,"nullable":false,"columnSize":200},{"name":"DOC_ID","dataType":12,"primaryKey":false,"nullable":true,"columnSize":200},{"name":"VALUE","dataType":12,"primaryKey":false,"nullable":true,"columnSize":200}],"indexs":[{"name":"PRIMARY","tableName":"auth_finddocument﻿","columnName":"ID","unique":false,"type":3,"sort":"A"},{"name":"index_doc_id_auth_finddocument﻿","tableName":"auth_finddocument﻿","columnName":"DOC_ID","unique":true,"type":3,"sort":"A"}],"foreignKeys":[],"indexTotal":2,"suggestMsg":"<font color='green'>已经优化</font>","indexColumnNames":"ID,DOC_ID"}]}
```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

### **获取表信息**

------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/getTable?datasourceId={datasourceId}&formId={formId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| datasourceId  | 是       | 数据源id |
| formId        | 是       | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "datasource":{
            "id":"__AhqIuqXvRUzJGrv5okH",
            "uri":"/4.0功能示例.application/接口测试.datasource/接口测试.datasource",
            "name":"接口测试",
            "useType":"JDBC",
            "driverClass":"com.mysql.jdbc.Driver",
            "url":"jdbc:mysql://localhost:3307/obpm2_testcase?useUnicode=true&amp;characterEncoding=utf8&amp;useSSL=false",
            "username":"root",
            "password":"",
            "dbType":4,
            "poolsize":"300",
            "timeout":"3000",
            "jndiName":"",
            "providerUrl":"",
            "initialContextFactory":null,
            "urlPkgPrefixes":"",
            "securityPrincipal":"",
            "securityCredentials":"",
            "readonly":false,
            "readonlyUseType":"JDBC",
            "readonlyDriverClass":null,
            "readonlyUsername":null,
            "readonlyPassword":null,
            "readonlyUrl":null,
            "readonlyPoolsize":null,
            "readonlyTimeout":null,
            "readonlyDbType":0,
            "readonlyJndiName":null,
            "readonlyProviderUrl":null,
            "readonlyInitialContextFactory":null,
            "readonlyUrlPkgPrefixes":null,
            "readonlySecurityPrincipal":null,
            "readonlySecurityCredentials":null,
            "dbTypeName":"MYSQL"
        },
        "form":{
            "id":"__0YLxcnXBE1G5atft4oU",
            "uri":"/4.0功能示例.application/接口测试.module/请假测试.module/新的树形视图.form/新的树形视图.form",
            "name":"新的树形视图",
            "templatecontext":"&lt;table width="100%" border="1" cellpadding="1" cellspacing="1" style="border: 1px solid rgb(180, 204, 238);"&gt;
    &lt;tbody&gt;
        &lt;tr&gt;
            &lt;td style="border: 1px solid rgb(180, 204, 238);"&gt;价格&lt;/td&gt;
            &lt;td style="border: 1px solid rgb(180, 204, 238);"&gt;&lt;input classname="cn.myapps.runtime.dynaform.form.ejb.InputField" id="__zWckTYBnexDc5TXIhia" text="text" name="价格" texttype="text" fieldtype="VALUE_TYPE_VARCHAR" fieldkeyevent="Tabkey" readonlyshowvalonly="true" discript="" validaterule="" valuescript="" hiddenscript="" hiddenvalue="" hiddenprintscript="" printhiddenvalue="" readonlyscript="" refreshonchanged="false" isdefaultvalue="false" calculateonrefresh="false" mobile="true" numberpattern="" processdescription="[];[]" filtercondition="" validatelibs="" editmode="01" refreshmode="0" refreshfields="" /&gt;&lt;/td&gt;
        &lt;/tr&gt;
        &lt;tr&gt;
            &lt;td style="border: 1px solid rgb(180, 204, 238);"&gt;数量&lt;/td&gt;
            &lt;td style="border: 1px solid rgb(180, 204, 238);"&gt;&lt;input classname="cn.myapps.runtime.dynaform.form.ejb.InputField" id="__XFLVKHiE5xJ9Ap00cOF" text="text" name="数量" texttype="text" fieldtype="VALUE_TYPE_VARCHAR" fieldkeyevent="Tabkey" readonlyshowvalonly="true" discript="" validaterule="" valuescript="" hiddenscript="" hiddenvalue="" hiddenprintscript="" printhiddenvalue="" readonlyscript="" refreshonchanged="false" isdefaultvalue="false" calculateonrefresh="false" mobile="true" numberpattern="" processdescription="[];[]" filtercondition="" validatelibs="" editmode="01" refreshmode="0" refreshfields="" /&gt;&lt;/td&gt;
        &lt;/tr&gt;
        &lt;tr&gt;
            &lt;td style="border: 1px solid rgb(180, 204, 238);"&gt;规格&lt;/td&gt;
            &lt;td style="border: 1px solid rgb(180, 204, 238);"&gt;&lt;input classname="cn.myapps.runtime.dynaform.form.ejb.InputField" id="__YQLOa6bfWlQvqdtreJZ" text="text" name="规格" texttype="text" fieldtype="VALUE_TYPE_VARCHAR" fieldkeyevent="Tabkey" readonlyshowvalonly="true" discript="" validaterule="" valuescript="" hiddenscript="" hiddenvalue="" hiddenprintscript="" printhiddenvalue="" readonlyscript="" refreshonchanged="false" isdefaultvalue="false" calculateonrefresh="false" mobile="true" numberpattern="" processdescription="[];[]" filtercondition="" validatelibs="" editmode="01" refreshmode="0" refreshfields="" /&gt;&lt;/td&gt;
        &lt;/tr&gt;
    &lt;/tbody&gt;
&lt;/table&gt;
&lt;p&gt; &lt;/p&gt;
&lt;p&gt; &lt;/p&gt;",
            "type":1,
            "showLog":false,
            "showType":"pc",
            "showWaterMark":false,
            "activities":[
                {
                    "id":"__MffgKTeLriYBx9cyCPq",
                    "uri":"/4.0功能示例.application/接口测试.module/请假测试.module/新的树形视图.form/保存.activity/保存.activity",
                    "name":"保存",
                    "type":34,
                    "onActionForm":"选择",
                    "colorType":"default",
                    "readonly":false,
                    "startFlowScript":"							",
                    "editMode":0,
                    "flowShowType":"表单中显示流程操作",
                    "orderno":1,
                    "parentForm":"__0YLxcnXBE1G5atft4oU",
                    "jumpType":0,
                    "expSub":false,
                    "disableFlowNode":true,
                    "changeFlowOperator":true,
                    "changeFlowCc":true,
                    "dispatcherMode":0,
                    "jumpMode":0,
                    "jumpActOpenType":0,
                    "withOld":false,
                    "actionType":0,
                    "actionSelection":0,
                    "workFlowType":0,
                    "contextMenu":true,
                    "showInToolbar":true,
                    "transpond":"选择",
                    "targetList":"11e7-6614-49736da0-9cdb-af6bc8266ed2|",
                    "backAction":"/portal/dispatch/dynaform/document/content.jsp",
                    "afterAction":"/portal/dispatch/dynaform/document/content.jsp",
                    "actionUrl":"/portal/dynaform/activity/handle.action",
                    "fieldErrorsAction":"/portal/dispatch/dynaform/document/content.jsp"
                },
                {
                    "id":"__dX6ZLVsHfio8iE6TvoF",
                    "uri":"/4.0功能示例.application/接口测试.module/请假测试.module/新的树形视图.form/返回.activity/返回.activity",
                    "name":"返回",
                    "type":10,
                    "colorType":"default",
                    "readonly":false,
                    "editMode":0,
                    "orderno":2,
                    "parentForm":"__0YLxcnXBE1G5atft4oU",
                    "jumpType":0,
                    "expSub":true,
                    "disableFlowNode":true,
                    "changeFlowOperator":true,
                    "changeFlowCc":true,
                    "dispatcherMode":0,
                    "jumpMode":0,
                    "jumpActOpenType":0,
                    "withOld":false,
                    "actionType":0,
                    "actionSelection":0,
                    "workFlowType":0,
                    "contextMenu":false,
                    "showInToolbar":true,
                    "transpond":"选择",
                    "targetList":"11e7-6614-49736da0-9cdb-af6bc8266ed2|",
                    "backAction":"/portal/dispatch/dynaform/document/content.jsp",
                    "afterAction":"/",
                    "actionUrl":"/portal/dynaform/activity/handle.action",
                    "fieldErrorsAction":"/"
                }
            ],
            "version":1,
            "mappingStr":"{"formName":"新的树形视图","tableName":"","columnMappings":[]}",
            "checkout":false,
            "orderno":0,
            "permissionType":"public",
            "layoutType":"horizontal",
            "typeName":"NORMALFORM",
            "allFieldNames":[
                "价格",
                "数量",
                "规格"
            ],
            "inited":true
        },
        "table":null,
        "type":null,
        "description":null,
        "columnMetadatas":[

        ],
        "_columnMetadatas":{
            "rowCount":0,
            "linesPerPage":0,
            "pageNo":0,
            "datas":[
                {
                    "column":"ITEM_价格",
                    "field":"价格",
                    "fieldType":"字符串",
                    "type":"文本框",
                    "des":""
                },
                {
                    "column":"ITEM_数量",
                    "field":"数量",
                    "fieldType":"字符串",
                    "type":"文本框",
                    "des":""
                },
                {
                    "column":"ITEM_规格",
                    "field":"规格",
                    "fieldType":"字符串",
                    "type":"文本框",
                    "des":""
                }
            ],
            "pageCount":0
        },
        "_table":"TLK_新的树形视图"
    }
}
```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

### **同步表单字段**

------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/synFormTable?datasourceId={datasourceId}&formId={formId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| datasourceId  | 是       | 数据源id |
| formId        | 是       | 表单id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":"同步完成"}
```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

### 优化索引

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/optimization

|      |      |      |
| ---- | ---- | ---- |
|      |      |      |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "优化完成"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 获取数据源详情**

----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/{dataSourceId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| dataSourceId  |    是    | 数据源id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__7NipDH7Ai7b96SVpewP",
		"name": "修改datasource123",
		"useType": "JDBC",
		"driverClass": "com.mysql.jdbc.Driver",
		"url": "jdbc:mysql://localhost:3306/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
		"username": "root",
		"password": "root",
		"dbType": 4,
		"poolsize": "300",
		"timeout": "3000",
		"jndiName": null,
		"providerUrl": null,
		"initialContextFactory": null,
		"urlPkgPrefixes": null,
		"securityPrincipal": null,
		"securityCredentials": null,
		"dbTypeName": "MYSQL"
	}
}

```

**参数说明：**

| **参数**            | **说明**              |
|---------------------|-----------------------|
| errcode             | 返回码                |
| errmsg              | 状态码对应的信息文本  |
| data                | 返回数据              |
| $.data.id           | 数据源id              |
| $.data.name         | 数据源名称            |
| $.data.useType      | 使用类型              |
| $.data.dbType       | 数据库类型            |
| $.data.username     | 用户名称              |
| $.data.password     | 密码                  |
| $.data.driverClass  | 数据驱动              |
| $.data.url          | 地址                  |
| $.data.poolsize     | 连接池大小            |
| $.data.timeout      | 连接超时时间          |

### **新建数据源**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/datasources

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
	"name": "datasource123",
	"useType": "JDBC",
	"dbType": 4,
	"driverClass": "com.mysql.jdbc.Driver",
	"url": "jdbc:mysql://localhost:3306/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
	"username": "root",
	"password": "root",
	"poolsize": "300",
	"timeout": "3000",
	"readonly" : 是否开启读写分离,
	"readonlyUseType": 使用类型,
	"readonlyDbType": 数据库类型,
	"readonlyUsername": 用户名称,
	"readonlyDriverClass": 数据驱动,
	"readonlyPassword": 密码,
	"readonlyUrl": 地址,
	"readonlyPoolsize": 连接池大小,
	"readonlyTimeout": 连接超时时间,
	"readonlyJndiName": JNDI名称,
    "readonlyInitialContextFactory": "INITIAL_CONTEXT_FACTORY",
    "readonlyUrlPkgPrefixes": "URL_PKG_PREFIXES",
    "readonlyProviderUrl": "PROVIDER_URL",
    "readonlySecurityPrincipal": "SECURITY_PRINCIPAL",
    "readonlySecurityCredentials": "SECURITY_CREDENTIALS"
}
```

**包体参数说明：**

| **参数**     | **说明**              |
|--------------|-----------------------|
| name         | 数据源名称            |
| useType      | 使用类型              |
| dbType       | 数据库类型            |
| username     | 用户名称              |
| password     | 密码                  |
| driverClass  | 数据驱动              |
| url          | 地址                  |
| poolsize     | 连接池大小            |
| timeout      | 连接超时时间          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**            | **说明**              |
|---------------------|-----------------------|
| errcode             | 返回码                |
| errmsg              | 状态码对应的信息文本  |
| data                | 返回数据              |
| $.data.id           | 数据源id              |

### **获取数据源详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/{dataSourceId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| dataSourceId  |    是    | 数据源id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__7NipDH7Ai7b96SVpewP",
		"name": "修改datasource123",
		"useType": "JDBC",
		"driverClass": "com.mysql.jdbc.Driver",
		"url": "jdbc:mysql://localhost:3306/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
		"username": "root",
		"password": "root",
		"dbType": 4,
		"poolsize": "300",
		"timeout": "3000",
		"jndiName": null,
		"providerUrl": null,
		"initialContextFactory": null,
		"urlPkgPrefixes": null,
		"securityPrincipal": null,
		"securityCredentials": null,
		"dbTypeName": "MYSQL"
	}
}

```

**参数说明：**

| **参数**            | **说明**              |
|---------------------|-----------------------|
| errcode             | 返回码                |
| errmsg              | 状态码对应的信息文本  |
| data                | 返回数据              |
| $.data.id           | 数据源id              |
| $.data.name         | 数据源名称            |
| $.data.useType      | 使用类型              |
| $.data.dbType       | 数据库类型            |
| $.data.username     | 用户名称              |
| $.data.password     | 密码                  |
| $.data.driverClass  | 数据驱动              |
| $.data.url          | 地址                  |
| $.data.poolsize     | 连接池大小            |
| $.data.timeout      | 连接超时时间          |

### **新建数据源**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/datasources

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
	"name": "datasource123",
	"useType": "JDBC",
	"dbType": 4,
	"driverClass": "com.mysql.jdbc.Driver",
	"url": "jdbc:mysql://localhost:3306/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
	"username": "root",
	"password": "root",
	"poolsize": "300",
	"timeout": "3000",
	"readonly" : 是否开启读写分离,
	"readonlyUseType": 使用类型,
	"readonlyDbType": 数据库类型,
	"readonlyUsername": 用户名称,
	"readonlyDriverClass": 数据驱动,
	"readonlyPassword": 密码,
	"readonlyUrl": 地址,
	"readonlyPoolsize": 连接池大小,
	"readonlyTimeout": 连接超时时间,
	"readonlyJndiName": JNDI名称,
    "readonlyInitialContextFactory": "INITIAL_CONTEXT_FACTORY",
    "readonlyUrlPkgPrefixes": "URL_PKG_PREFIXES",
    "readonlyProviderUrl": "PROVIDER_URL",
    "readonlySecurityPrincipal": "SECURITY_PRINCIPAL",
    "readonlySecurityCredentials": "SECURITY_CREDENTIALS"
}
```

**包体参数说明：**

| **参数**     | **说明**              |
|--------------|-----------------------|
| name         | 数据源名称            |
| useType      | 使用类型              |
| dbType       | 数据库类型            |
| username     | 用户名称              |
| password     | 密码                  |
| driverClass  | 数据驱动              |
| url          | 地址                  |
| poolsize     | 连接池大小            |
| timeout      | 连接超时时间          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**            | **说明**              |
|---------------------|-----------------------|
| errcode             | 返回码                |
| errmsg              | 状态码对应的信息文本  |
| data                | 返回数据              |
| $.data.id           | 数据源id              |

### **更新数据源**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/datasources/{dataSourceId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| dataSourceId  |    是    | 数据源id |

**请求包体：**

```
{
	"name": "datasource123",
	"useType": "JDBC",
	"dbType": 4,
	"driverClass": "com.mysql.jdbc.Driver",
	"url": "jdbc:mysql://localhost:3306/obpm2_testcase?useUnicode=true&characterEncoding=utf8&useSSL=false",
	"username": "root",
	"password": "root",
	"poolsize": "300",
	"timeout": "3000",
	"readonly" : 是否开启读写分离,
	"readonlyUseType": 使用类型,
	"readonlyDbType": 数据库类型,
	"readonlyUsername": 用户名称,
	"readonlyDriverClass": 数据驱动,
	"readonlyPassword": 密码,
	"readonlyUrl": 地址,
	"readonlyUrl": 地址,
	"readonlyPoolsize": 连接池大小,
	"readonlyTimeout": 连接超时时间,
	"readonlyJndiName": JNDI名称,
    "readonlyInitialContextFactory": "INITIAL_CONTEXT_FACTORY",
    "readonlyUrlPkgPrefixes": "URL_PKG_PREFIXES",
    "readonlyProviderUrl": "PROVIDER_URL",
    "readonlySecurityPrincipal": "SECURITY_PRINCIPAL",
    "readonlySecurityCredentials": "SECURITY_CREDENTIALS"
}
```

**包体参数说明：**

| **参数**     | **说明**              |
|--------------|-----------------------|
| name         | 数据源名称            |
| useType      | 使用类型              |
| dbType       | 数据库类型            |
| username     | 用户名称              |
| password     | 密码                  |
| driverClass  | 数据驱动              |
| url          | 地址                  |
| poolsize     | 连接池大小            |
| timeout      | 连接超时时间          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除数据源（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/{applicationId}/datasources

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明**   |
|----------|------------|
| id       | 数据源id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **测试数据源**
----------
**请求方式：** POST
**请求地址：** /api/designtime/applications/{applicationId}/testdatasources

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "username": "username",
    "password": "password",
    "driverClass": "driverClass",
    "url": "url"
}
```

**包体参数说明：**

| **参数**     | **说明**              |
|--------------|-----------------------|
| username     | 用户名称              |
| password     | 密码                  |
| driverClass  | 数据驱动              |
| url          | 地址                  |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 18.  **函数库（Macros）**
### **获取函数库列表（可根据名字查询）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/macros?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 否       | 查询名称 |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "__LMPNOEdhFExRaOYSp4s",
			"name": "单元测试666",
			"content": "12345",
			"version": 0
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 函数库id             |
| $.data.name        | 函数库名称           |

### **获取函数库详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/macros/{macroId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| macroId       |    是    | 函数库id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id",
            "name": "name",
            "content": "content"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 函数库id             |
| $.data.name        | 函数库名称           |
| $.data.content     | 内容                 |

### **新建函数库**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/macros

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "content": "content"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 函数库名称           |
| content     | 内容                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 函数库id             |

### **更新函数库**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/macros/{macroId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| macroId       |    是    | 函数库id   |

**请求包体：**

```
{
    "name": "name",
    "content": "content"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 函数库名称           |
| content     | 内容                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除函数库（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/{applicationId}/macros

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 函数库id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 19.  **样式库（Styles）**
### **获取样式库列表（可根据名字查询）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/styles?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 否       | 查询名称 |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 2,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "IYjUHIBjrlGocjzzuxu",
			"name": "视图样式",
			"content": ".listDataThTd{\nwhite-space: nowrap;\nbackground-color: #DC143C;\n}",
			"version": 0,
			"lastmodifytime": "2019-09-11T09:10:45.902+0000"
		}, {
			"id": "HNaKnPtT0bKlXoTGqkx",
			"name": "输入框字体-红",
			"content": ".form-control{\n      color: red;\n}",
			"version": 0,
			"lastmodifytime": "2019-08-20T12:59:07.095+0000"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 样式库id             |
| $.data.name        | 样式库名称           |

### **获取样式库详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/styles/{styleId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| styleId       |    是    | 样式库id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id",
            "name": "name",
            "content": "content"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 样式库id             |
| $.data.name        | 样式库名称           |
| $.data.content     | 内容                 |

### **新建样式库**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/styles

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "content": "content"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 样式库名称           |
| content     | 内容                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 样式库id             |

### **更新样式库**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/styles/{styleId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| styleId       |    是    | 样式库id |

**请求包体：**

```
{
    "name": "name",
    "content": "content"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 样式库名称           |
| content     | 内容                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除样式库（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/{applicationId}/styles

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 样式库id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | 返回数据 |

## 20.  **校验库（Validates）**
### **获取校验库列表（可根据名字查询）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/validates?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| name          |    是    | 查询名称 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "__7QMu8RivfLn2Y4O4TDL",
			"name": "单元测试666",
			"content": "12345",
			"version": 0,
			"lastmodifytime": null
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 校验库id             |
| $.data.name        | 校验库名称           |

### **获取校验库详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/validates/{validId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| validId       |    是    | 校验库id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id",
            "name": "name",
            "content": "content"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 校验库id             |
| $.data.name        | 校验库名称           |
| $.data.content     | 内容                 |

### **新建校验库**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/validates

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "content": "content"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 校验库名称           |
| content     | 内容                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 校验库id             |

### **更新校验库**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/validates/{validId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |
| validId       |    是    | 校验库id |

**请求包体：**

```
{
    "name": "name",
    "content": "content"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 校验库名称           |
| content     | 内容                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除校验库（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/{applicationId}/validates

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| id          | 校验库id             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

## 21. **多语言（Mulitlangs）**
### **获取多语言列表（可根据标签查询）**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/mulitlangs?label={label}&text={text}&type={type}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| label         | 否       | 查询标签 |
| text          | 否       | 文本     |
| type          | 否       | 类型     |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"linesPerPage": 10,
		"pageCount": 1,
		"data": [{
			"id": "5fj9rctxLyQlJGLBovj",
			"name": "Area Selection",
			"type": 1,
			"label": "地区选择",
			"text": "Area Selection"
		}, {
			"id": "d3sCqfvz4A3OM6DRJOZ",
			"name": "地区选择",
			"type": 2,
			"label": "地区选择",
			"text": "地区选择"
		}, {
			"id": "tZTirflaktsq4CM8MES",
			"name": "地區選擇",
			"type": 3,
			"label": "地区选择",
			"text": "地區選擇"
		}],
		"pageNo": 1,
		"rowCount": 3
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 多语言id             |
| $.data.name        | 多语言名称           |
| $.data.type        | 类型                 |
| $.data.label       | 标签                 |
| $.data.text        | 文本                 |

### **获取多语言详情**
----------
**请求方式：** GET  
**请求地址：** /api/designtime/applications/mulitlangs/{mulitlangId}

**参数说明：**

| **参数**    | **必须** | **说明** |
| ----------- | -------- | -------- |
| mulitlangId | 是       | 多语言id |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "5fj9rctxLyQlJGLBovj",
		"name": "Area Selection",
		"type": 1,
		"label": "地区选择",
		"text": "Area Selection"
	}
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 多语言id             |
| $.data.name        | 多语言名称           |
| $.data.type        | 类型                 |
| $.data.label       | 标签                 |
| $.data.text        | 文本                 |

### **新建多语言**
----------
**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/mulitlangs

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId |    是    | 软件id   |

**请求包体：**

```
{
    "type": "type",
    "label": "label",
    "text": "text"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 多语言名称           |
| type        | 类型                 |
| label       | 标签                 |
| text        | 文本                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 多语言id             |

### **更新多语言**
----------
**请求方式：** PUT  
**请求地址：** /api/designtime/applications/mulitlangs

**参数说明：**

**请求包体：**

```
{
    "id":"id",
    "parentId":"parentId",
    "applicationid":"applicationid",
    "type": "type",
    "label": "label",
    "text": "text"
}
```

**包体参数说明：**

| **参数**    | **说明**             |
|-------------|----------------------|
| name        | 多语言名称           |
| type        | 类型                 |
| label       | 标签                 |
| text        | 文本                 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **删除多语言（可批量）**
----------
**请求方式：** DELETE
**请求地址：** /api/designtime/applications/mulitlangs

**参数说明：**

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
|----------|----------|
| id       | 多语言id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |

### **重新加载语言属性**
----------
**请求方式：** GET
**请求地址：** /api/designtime/applications/reloadLanguage

**参数说明：**

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok" 
}

```

**参数说明：**

| **参数**           | **说明**             |
|--------------------|----------------------|
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | 多语言id             |
| $.data.name        | 多语言名称           |
| $.data.type        | 类型                 |
| $.data.label       | 标签                 |
| $.data.text        | 文本                 |

## 22.  **文件上传**

### 上传文件

**请求方式：** POST  
**请求地址：** /api/designtime/applications/uploads

**参数说明：**

| **参数** | **必须** | **说明**           |
| -------- | -------- | ------------------ |
| files    | 是       | 上传文件二进制     |
| icon     | 否       | 上传文件是否为图标 |
| path     | 否       | 上传文件路径       |

**权限说明：**

无。

**返回结果：**

```
{
	"data": [{
		"fileName": "import_user_sample.xlsx",
		"filePath": "\\uploads\\2019\\8fd094db-b2d8-4114-ae00-ef94f004c38d.xlsx"
	}],
	"errcode": 0,
	"errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**                 |      |
| -------- | ------------------------ | ---- |
| errcode  | 返回码（0=成功，1=失败） |      |
| errmsg   | 对返回码的文本描述内容   |      |

## 23.  脚本编辑器模块

### 脚本预编译

**请求方式：** POST  
**请求地址：** /api/designtime/applications/iscript/compile

**请求包体：**

```
{
    "iscriptString": "iscriptString"
}
```

**包体参数说明：**

| **参数**      | **说明** |
| ------------- | -------- |
| iscriptString | 脚本内容 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "SUCCESS!"
}
```

**参数说明：**

| **参数** | **说明**                 |      |
| -------- | ------------------------ | ---- |
| errcode  | 返回码（0=成功，1=失败） |      |
| errmsg   | 对返回码的文本描述内容   |      |

### 脚本帮助接口

**请求方式：** GET  
**请求地址：** /api/designtime/applications/iscript/getIscriptHelp

**请求包体：**

```

```

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "html"
}
```

**参数说明：**

| **参数** | **说明**                 |      |
| -------- | ------------------------ | ---- |
| errcode  | 返回码（0=成功，1=失败） |      |
| errmsg   | 对返回码的文本描述内容   |      |

## 24.  **视图链接模块（Links）**

### **获取链接列表**

------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/links?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}&type={type}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 否       | 查询名称 |
| type          | 否       | 类型     |
| pageNo        | 否       | 页码     |
| linesPerPage  | 否       | 页条数   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "__iapOm9FQ6f5rs0n7ZBB",
			"uri": "/4.0功能示例.application/测试.link/测试.link",
			"name": "测试",
			"type": "01",
			"moduleid": "__nIR7tcVaHuUwph5r4cc",
			"directory": "portal",
			"actionContent": "__dd0uVSyq3HWGMbCBx1H",
			"queryString": "[]"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**    | **说明**             |
| ----------- | -------------------- |
| errcode     | 返回码               |
| errmsg      | 状态码对应的信息文本 |
| data        | 返回数据             |
| $.data.id   | 链接id               |
| $.data.name | 链接名称             |

### **获取链接详情**

------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/links/{linkId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| linkId   | 是       | 链接id   |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id",
            "name": "name",
            "content": "content"
    }
}

```

**参数说明：**

| **参数**       | **说明**             |
| -------------- | -------------------- |
| errcode        | 返回码               |
| errmsg         | 状态码对应的信息文本 |
| data           | 返回数据             |
| $.data.id      | 链接id               |
| $.data.name    | 链接名称             |
| $.data.content | 内容                 |

### 新建链接

------

**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/links

**参数说明：**

**请求包体：**

```
{
	"name": "单元测试666",
	"applicationid": "sOZu9kthmxyP8qQfq0e",
	"parentId": "sOZu9kthmxyP8qQfq0e",
	"directory":"portal",
	"actionContent":"actionContent",
	"type":"01",
	"queryString":[],
	"description":"description",
	"id": "id "
}
```

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### 

### 更新链接

------

**请求方式：** PUT  
**请求地址：** /api/designtime/applications/links

**参数说明：**

**请求包体：**

```
{
	"name": "单元测试666",
	"applicationid": "sOZu9kthmxyP8qQfq0e",
	"parentId": "sOZu9kthmxyP8qQfq0e",
	"directory":"portal",
	"actionContent":"actionContent",
	"type":"01",
	"queryString":[],
	"description":"description",
	"id": "id "
}
```

**包体参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### **删除链接（可批量）**

------

**请求方式：** DELETE
**请求地址：** /api/designtime/applications/links

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
| -------- | -------- |
| id       | 样式库id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 返回数据             |

## 25.  **权限配置**

### **批量更新授权配置**

**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/permissions

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| applicationId    | 是       | 软件id |

**权限说明：**

无。
**请求包体：**
```
{
    "roles": [
        "id1",
        "id2"
    ],
    "resources": [
        {
            "id":"id",
            "checked":false
        },
        {
            "id2":"id2",
            "checked":false
        }
    ],
    "views": [
        {
            "id": "id1",
            "activities": [
                {
                    "viewId":"viewId",
                    "checked":false
                },
                {
                    "id1":"id1",
                    "checked":false
                },
                {
                    "id2":"id2",
                    "checked":false
                }
            ]
        },
        {
            "id": "id1",
            "activities": [
				{
                    "viewId":"viewId",
                    "checked":false
                },
                {
                    "id1":"id1",
                    "checked":false
                },
                {
                    "id2":"id2",
                    "checked":false
                }
            ]
        }
    ],
    "forms": [
        {
            "id": "id1",
            "activities": [
				{
                    "formId":"formId",
                    "checked":false
                },
                {
                    "id1":"id1",
                    "checked":false
                },
                {
                    "id2":"id2",
                    "checked":false
                }
            ]
        },
        {
            "id": "id1",
            "activities": [
				{
                    "formId":"formId",
                    "checked":false
                },
                {
                    "id1":"id1",
                    "checked":false
                },
                {
                    "id2":"id2",
                    "checked":false
                }
            ]
        }
    ]
}
```
**参数说明：**
| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| roles    | 是       | 角色id集合 |
| resources    | 是       | 菜单id集合 |
| views    | 是       | 视图对象集合 |
| forms  | 是       | 表单对象集合 |
| activities    | 是       | 按钮id集合(打开的复选框是该表单或者视图的id) |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data   | 资源对象   |

### **查询pc菜单配置资源列表(根据上级)**
------------

服务器返回根据角色的配置资源列表。

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/permissions/pc?parentId={parentId}&roleId={roleId}

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| applicationId    | 是       | 软件id |
| roleId    | 否       | 角色id |
| parentId    | 否       | 上级id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "__ryzSjcrmaKPwyuhTff3",
            "parentId": "__UIULaYjPTHL3iD9hgwf",
            "name": "pc菜单",
            "permissionType": "private",
            "checked": false,
            "hasChild":true
        }
    ]
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data   | 资源对象   |

### **查询mobile菜单配置资源列表(根据上级)**
------------

服务器返回根据角色的配置资源列表。

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/permissions/mobile?parentId={parentId}&roleId={roleId}

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| applicationId    | 是       | 软件id |
| roleId    | 否       | 角色id |
| parentId    | 否       | 上级id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "__ryzSjcrmaKPwyuhTff3",
            "parentId": "__UIULaYjPTHL3iD9hgwf",
            "name": "mobile菜单",
            "permissionType": "private",
            "checked": false,
            "hasChild":true
        }
    ]
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data   | 资源对象   |

### **查询所属模块的表单或视图配置资源列表**
------------

服务器返回根据所属模块的表单或视图配置资源列表。

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/modules/{moduleId}/permissions?roleId={roleId}

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| applicationId    | 是       | 软件id |
| roleId    | 否       | 角色id |
| moduleId    | 是       | 模块id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "forms": [
            {
                "id": "__b4fL3h642C0rwag7gCr",
                "name": "简单表单",
                "permissionType": "private",
                "activities": [
                    {
                        "id": "__i4VzpphJmShgDtVmNTt",
                        "name": "保存",
                        "checked": true
                    },
                    {
                        "id": "__lngHijzzyKLno6ygnv2",
                        "name": "返回",
                        "checked": true
                    },
                    {
                        "id": "__b4fL3h642C0rwag7gCr",
                        "name": "打开",
                        "checked": true
                    }
                ]
            }
        ],
        "views": [
            {
                "id": "__zNzDsBiB52n6EyL23C3",
                "name": "简单表单",
                "permissionType": "public",
                "activities": [
                    {
                        "id": "__KfyHewefMqinj9xFeKt",
                        "name": "新建",
                        "checked": true
                    },
                    {
                        "id": "__Ppp3tdmenaljrXpND57",
                        "name": "删除",
                        "checked": true
                    },
                    {
                        "id": "__zNzDsBiB52n6EyL23C3",
                        "name": "打开",
                        "checked": true
                    }
                ]
            }
        ]
    }
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data   | 资源对象   |

## 26.  **Eip（Eips）**

### **获取eip列表（可根据名字查询）**

----------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/eips?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| name          | 是       | 名称     |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "__UFRPx5256ckmTiK20Op",
                "uri": "/4.0功能示例.application/test2.eipconfig",
                "name": "test2",
                "description": "1123",
                "xml": "aaaaaa"
            }
        ],
        "pageCount": 1
    }
}
```

**参数说明：**

| **参数**           | **说明**             |
| ------------------ | -------------------- |
| errcode            | 返回码               |
| errmsg             | 状态码对应的信息文本 |
| data               | 返回数据             |
| $.data.id          | id                   |
| $.data.name        | 名称                 |
| $.data.description | 描述                 |
| $.data.xml         | xml字符串            |

### **获取eip详情**

----------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/eips/{eipId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| eipId         | 是       | id       |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "id": "id",
            "name": "name",
            "xml": "xml",
            "description":"description"
    }
}

```

**参数说明：**

| **参数**       | **说明**             |
| -------------- | -------------------- |
| errcode        | 返回码               |
| errmsg         | 状态码对应的信息文本 |
| data           | 返回数据             |
| $.data.id          | id               |
| $.data.name        | 名称             |
| $.data.description | 描述             |
| $.data.xml         | xml字符串        |

### **新建eip**

----------

**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/eips

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |

**请求包体：**

```
{
    "name": "name",
    "xml": "xml",
    "description":"description"
}
```

**包体参数说明：**

| **参数** | **说明**   |
| -------- | ---------- |
| name        | 名称                 |
| description | 描述                 |
| xml         | xml字符串            |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**  | **说明**             |
| --------- | -------------------- |
| errcode   | 返回码               |
| errmsg    | 状态码对应的信息文本 |
| data      | 返回数据             |
| $.data.id | id             |

### **更新eip**

----------

**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/eips/{eipId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| eipId         | 是       | 校验库id |

**请求包体：**

```
{
   "name": "name",
   "xml": "xml",
   "description":"description"
}
```

**包体参数说明：**

| **参数** | **说明**   |
| -------- | ---------- |
| name     | 校验库名称 |
| content  | 内容       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### **删除eip（可批量）**

----------

**请求方式：** DELETE
**请求地址：** /api/designtime/applications/eips

**参数说明：**

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
| -------- | -------- |
| id       | id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

## 27.  **Api中心（Apis）**

### **获取api列表（可根据名字查询）**

----------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/apis?name={name}&requestType={requestType}&status={status}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**     |
| ------------- | -------- | ------------ |
| applicationId | 是       | 软件id       |
| name          | 否       | 名称         |
| requestType   | 否       | 请求类型     |
| status        | 否       | 状态         |
| pageNo        | 否       | 页数         |
| linesPerPage  | 否       | 每页显示条数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "__ZKvjRFLYzO7290vLgUF",
                "uri": "/trunk功能示例.application/获取用户.api",
                "fileUrl": "file:///D:/spy/trunk2018/obpm-demo/workspace/trunk功能示例.application/获取用户.api",
                "name": "获取用户",
                "status": "test",
                "apiGroup": "yBQuYnX8AS9vYx217dB",
                "encode": "UTF-8",
                "requestType": "get",
                "requestUrl": "/api/users",
                "tags": "Accept-Encoding;Accept",
                "responseType": "json",
                "responseScript": "&#13;//给表单有选项脚本的控件创建选项@nbsp;@nbsp;(选项脚本)&#13;(function(){&#13;var@nbsp;opts@nbsp;=@nbsp;$TOOLS.createOptions();@nbsp;//创建指定类对象&#13;opts.add(@quot;A@quot;,@quot;a@quot;);&#13;opts.add(@quot;B@quot;,@quot;b@quot;);&#13;opts.add(@quot;C@quot;,@quot;c@quot;);&#13;return@nbsp;opts;&#13;})())"
            }
        ],
        "pageCount": 1
    }
}
```

**参数说明：**

| **参数**                    | **说明**             |
| --------------------------- | -------------------- |
| errcode                     | 返回码               |
| errmsg                      | 状态码对应的信息文本 |
| data                        | 返回数据             |
| $.data.datas.id             | id                   |
| $.data.datas.name           | 名称                 |
| $.data.datas.status         | 状态                 |
| $.data.datas.apiGroup       | 分组                 |
| $.data.datas.encode         | 编码格式             |
| $.data.datas.requestScheme  | 请求协议             |
| $.data.datas.requestType    | 请求类型             |
| $.data.datas.requestUrl     | 请求路径             |
| $.data.datas.tags           | 标签                 |
| $.data.datas.responseType   | 响应数据类型         |
| $.data.datas.responseScript | 返回结果脚本         |

### **获取api详情**

----------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/apis/{apiId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| apiId    | 是       | 主键     |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "__pJRiHEHgZdZhsKKvW8b",
        "uri": "/trunk功能示例.application/获取用户.api",
        "fileUrl": "file:///D:/spy/trunk2018/obpm-demo/workspace/trunk功能示例.application/获取用户.api",
        "name": "获取用户",
        "status": "publish",
        "apiGroup": "yBQuYnX8AS9vYx217dB",
        "encode": "UTF-8",
        "requestScheme": "http",
        "requestType": "get",
        "requestUrl": "/api/users",
        "tags": "Accept-Encoding;Accept",
        "responseType": "json",
        "responseScript": "&#13;//给表单有选项脚本的控件创建选项@nbsp;@nbsp;(选项脚本)&#13;(function(){&#13;var@nbsp;opts@nbsp;=@nbsp;$TOOLS.createOptions();@nbsp;//创建指定类对象&#13;opts.add(@quot;A@quot;,@quot;a@quot;);&#13;opts.add(@quot;B@quot;,@quot;b@quot;);&#13;opts.add(@quot;C@quot;,@quot;c@quot;);&#13;return@nbsp;opts;&#13;})())"
    }
}

```

**参数说明：**

| **参数**              | **说明**             |
| --------------------- | -------------------- |
| errcode               | 返回码               |
| errmsg                | 状态码对应的信息文本 |
| data                  | 返回数据             |
| $.data.id             | id                   |
| $.data.name           | 名称                 |
| $.data.status         | 状态                 |
| $.data.apiGroup       | 分组                 |
| $.data.encode         | 编码格式             |
| $.data.requestScheme  | 请求协议             |
| $.data.requestType    | 请求类型             |
| $.data.requestUrl     | 请求路径             |
| $.data.tags           | 标签                 |
| $.data.responseType   | 响应数据类型         |
| $.data.responseScript | 返回结果脚本         |

### **新建api**

----------

**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/apis

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |

**请求包体：**

```
{
    "name": "获取用户",
    "status": "publish",
    "apiGroup": "yBQuYnX8AS9vYx217dB",
    "encode": "UTF-8",
    "requestScheme": "http",
    "requestType": "get",
    "requestUrl": "/api/users",
    "tags": "Accept-Encoding;Accept",
    "responseType": "json",
    "responseScript": "&#13;//给表单有选项脚本的控件创建选项@nbsp;@nbsp;(选项脚本)&#13;(function(){&#13;var@nbsp;opts@nbsp;=@nbsp;$TOOLS.createOptions();@nbsp;//创建指定类对象&#13;opts.add(@quot;A@quot;,@quot;a@quot;);&#13;opts.add(@quot;B@quot;,@quot;b@quot;);&#13;opts.add(@quot;C@quot;,@quot;c@quot;);&#13;return@nbsp;opts;&#13;})())"
}
```

**包体参数说明：**

| 参数           | 说明         |
| -------------- | ------------ |
| name           | 名称         |
| status         | 状态         |
| apiGroup       | 分组         |
| encode         | 编码格式     |
| requestScheme  | 请求协议     |
| requestType    | 请求类型     |
| requestUrl     | 请求路径     |
| tags           | 标签         |
| responseType   | 响应数据类型 |
| responseScript | 返回结果脚本 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**  | **说明**             |
| --------- | -------------------- |
| errcode   | 返回码               |
| errmsg    | 状态码对应的信息文本 |
| data      | 返回数据             |
| $.data.id | id                   |

### **更新api**

----------

**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/apis/{apiId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| apiId         | 是       | 主键     |

**请求包体：**

```
{
    "name": "获取用户",
    "status": "publish",
    "apiGroup": "yBQuYnX8AS9vYx217dB",
    "encode": "UTF-8",
    "requestScheme": "http",
    "requestType": "get",
    "requestUrl": "/api/users",
    "tags": "Accept-Encoding;Accept",
    "responseType": "json",
    "responseScript": "&#13;//给表单有选项脚本的控件创建选项@nbsp;@nbsp;(选项脚本)&#13;(function(){&#13;var@nbsp;opts@nbsp;=@nbsp;$TOOLS.createOptions();@nbsp;//创建指定类对象&#13;opts.add(@quot;A@quot;,@quot;a@quot;);&#13;opts.add(@quot;B@quot;,@quot;b@quot;);&#13;opts.add(@quot;C@quot;,@quot;c@quot;);&#13;return@nbsp;opts;&#13;})())"
}
```

**包体参数说明：**

| 参数           | 说明         |
| -------------- | ------------ |
| name           | 名称         |
| status         | 状态         |
| apiGroup       | 分组         |
| encode         | 编码格式     |
| requestScheme  | 请求协议     |
| requestType    | 请求类型     |
| requestUrl     | 请求路径     |
| tags           | 标签         |
| responseType   | 响应数据类型 |
| responseScript | 返回结果脚本 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### **删除api（可批量）**

----------

**请求方式：** DELETE
**请求地址：** /api/designtime/applications/apis

**参数说明：**

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
| -------- | -------- |
| id       | id       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

## 28.  **Api分组（ApiGroups）**

### **获取api分组列表（可根据名字查询）**

----------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/{applicationId}/apigroups?name={name}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**     |
| ------------- | -------- | ------------ |
| applicationId | 是       | 软件id       |
| name          | 否       | 名称         |
| pageNo        | 否       | 页数         |
| linesPerPage  | 否       | 每页显示条数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "__ZKvjRFLYzO7290vLgUF",
                "uri": "/trunk功能示例.application/获取用户分组.apigroup",
                "fileUrl": "file:///D:/spy/trunk2018/obpm-demo/workspace/trunk功能示例.application/获取用户分组.apigroup",
                "name": "获取用户分组"
            }
        ],
        "pageCount": 1
    }
}
```

**参数说明：**

| **参数**          | **说明**             |
| ----------------- | -------------------- |
| errcode           | 返回码               |
| errmsg            | 状态码对应的信息文本 |
| data              | 返回数据             |
| $.data.datas.id   | id                   |
| $.data.datas.name | 名称                 |

### **获取api分组详情**

----------

**请求方式：** GET  
**请求地址：** /api/designtime/applications/apigroups/{apiGroupId}

**参数说明：**

| **参数**   | **必须** | **说明** |
| ---------- | -------- | -------- |
| apiGroupId | 是       | 主键     |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "__pJRiHEHgZdZhsKKvW8b",
        "uri": "/trunk功能示例.application/获取用户.api",
        "fileUrl": "file:///D:/spy/trunk2018/obpm-demo/workspace/trunk功能示例.application/获取用户.api",
        "name": "获取用户"
    }
}

```

**参数说明：**

| **参数**    | **说明**             |
| ----------- | -------------------- |
| errcode     | 返回码               |
| errmsg      | 状态码对应的信息文本 |
| data        | 返回数据             |
| $.data.id   | id                   |
| $.data.name | 名称                 |

### **新建api**分组

----------

**请求方式：** POST  
**请求地址：** /api/designtime/applications/{applicationId}/apigroups

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |

**请求包体：**

```
{
    "name": "获取用户分组"
}
```

**包体参数说明：**

| 参数 | 说明 |
| ---- | ---- |
| name | 名称 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "id"
    }
}

```

**参数说明：**

| **参数**  | **说明**             |
| --------- | -------------------- |
| errcode   | 返回码               |
| errmsg    | 状态码对应的信息文本 |
| data      | 返回数据             |
| $.data.id | id                   |

### **更新api**分组

----------

**请求方式：** PUT  
**请求地址：** /api/designtime/applications/{applicationId}/apigroups/{apiGroupId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| apiGroupId    | 是       | 主键     |

**请求包体：**

```
{
    "name": "获取用户分组"
}
```

**包体参数说明：**

| 参数 | 说明 |
| ---- | ---- |
| name | 名称 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

### **删除api分组（可批量）**

----------

**请求方式：** DELETE
**请求地址：** /api/designtime/applications/apigroups

**参数说明：**

**请求包体：**

```
[
    "id1",
    "id2"
]
```

**包体参数说明：**

| **参数** | **说明** |
| -------- | -------- |
| id       | id       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**             |
| -------- | -------------------- |
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |

## 29.  **公共（Helps）**

### **获取系统信息列表（可根据名称查询）**
----------
**请求方式：** GET
**请求地址：** /api/designtime/systeminfo?name={name}&type={type}

**参数说明：**

| **参数**     | **必须** | **说明** |
| ------------ | -------- | -------- |
| name         | 否       | 查询名称 |
| type         | 否       | 类型     |
| pageNo       | 否       | 当前页数 |
| linesPerPage | 否       | 每页行数 |

**请求包体：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "4739dbd4-202c-405f-8f54-997f7124856f",
			"name": "WeiOA365 2.0_UPGRADE",
			"version_name": "WeiOA365 2.0_UPGRADE",
			"version_number": "WeiOA365 2.0_UPGRADE",
			"upgrade_date": "2018-05-30T06:32:45.527+0000",
			"type": 3,
			"remark": "数据迁移成功"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数**                   | **说明**             |
|----------------------------|----------------------|
| errcode                    | 返回码               |
| errmsg                     | 状态码对应的信息文本 |
| data                       | 返回数据             |
| $.data.versioninfo         | 版本信息             |
| $.data.versions            | 日志列表             |
| $.data.versions.id         | 日志id               |
| $.data.versions.name       | 版本名称             |
| $.data.versions.version    | 版本号               |
| $.data.versions.type       | 类型                 |
| $.data.versions.updatetime | 升级日期             |
| $.data.versions.remarks    | 备注                 |

